
;------------------------------------------------------------------
;tiny xms driver - version 1.0 - copyright (c) 1997, Xavier Defrang
;------------------------------------------------------------------

wptr            equ     word ptr
dptr            equ     dword ptr

embstruc        struc                           ;structure for data xfers
						;between dos mem and xms
len             dd      ?
srchandle       dw      ?
srcoff          dd      ?
dsthandle       dw      ?
dstoff          dd      ?

		ends

;----------------------------------------------------------------------
; IN: none
;OUT: ax = xms version
;     bx = xms driver version   
;     dx = hma state             
;     cf = 1 (if an error occurs or if the driver is obsolete)
;----------------------------------------------------------------------

xms_init:       mov     ax, 4300h        
		int     2fh                     ;xms driver present?
		cmp     al, 80h
		jne     xms_init_err
		mov     ax, 4310h
		int     2fh                     ;get xms driver address
		mov     wptr [xmsdriver], bx
		mov     wptr [xmsdriver+2], es
		xor     ah, ah                  
		call    dptr [xmsdriver]
		cmp     ax, 0200h               ;check-up driver version
		jbe     xms_init_err
		clc
		ret
xms_init_err:   stc
		ret

;----------------------------------------------------------------------
; IN: none
;OUT: ax = size of the largest block available (in kb)
;     dx = total size of the xms memory on the system (in kb)            
;----------------------------------------------------------------------

xms_avail:      mov     ah, 08h
		call    dptr [xmsdriver]
		ret

;----------------------------------------------------------------------
; IN: dx = block size in kb
;OUT: ax = error code
;     dx = handle
;----------------------------------------------------------------------

xms_alloc:      mov     ah, 09h
		call    dptr [xmsdriver]
		ret

;----------------------------------------------------------------------
; IN: dx = handle
;OUT: ax = error code
;----------------------------------------------------------------------

xms_free:       mov     ah, 0ah
		call    dptr [xmsdriver]
		ret

;----------------------------------------------------------------------
; IN: ds:si = emb structure
;OUT: ax = error code
;----------------------------------------------------------------------

xms_move:       mov     ah, 0bh
		call    dptr [xmsdriver]
		ret

xmsdriver       dd      0                       ;zerodata!

