/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.util.*;

/**
 *
 * @see Grid
 * @see TextGrid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class Organizer extends Frame {
   public Organizer() {
      setLayout(new BorderLayout());
      setMenuBar(new OrganizerMenu());
      
      add("Center", folder = new Folder());
      folder.add("MCalendar", yearcal = new YearCal(3, 4));
      yearcal.setRuling(Grid.VERTICAL | Grid.HORIZONTAL);
      folder.add("To Do", new ToDo());
      folder.add("Notes", new Notes());
      folder.add("Address", new Address());
      
      int year = (new Date()).getYear();
      months = new MonthWin[12];
      for(int i = 0; i < 12; i++) {
	 months[i] = new MonthWin(this, year, i);
      }
   }

   public boolean action(Event e, Object arg) {
      if(e.target instanceof MenuItem) {
	 if(arg.equals("Exit")) {
	    dispose();
	    System.exit(0);
	 }
	 else {
	    folder.toFront(arg.toString());
	 }
      }
      else if(e.target instanceof YearCal) {
	 int m = ((YearCal) e.target).getStartMonth();
	 if(m >= 0) {
	    months[m].pack();
	    months[m].show();
	 }
      }
      
      return true;
   }
   
   private Folder folder;
   private YearCal yearcal;
   private MonthWin months[];
   
   public static void main(String argv[]) {
      Organizer org = new Organizer();
      org.pack();
      org.show();
   }
}

class OrganizerMenu extends MenuBar {
   public OrganizerMenu() {
      Menu file = new Menu("File");
      file.add(new MenuItem("Exit"));
      
      Menu section = new Menu("Sections");
      section.add(new MenuItem("MCalendar"));
      section.add(new MenuItem("To Do"));
      section.add(new MenuItem("Notes"));
      section.add(new MenuItem("Address"));

      Menu help = new Menu("Help");
      setHelpMenu(help);
	 
      add(file);
      add(section);
      add(help);
   }
}

class MonthWin extends Dialog {
   public MonthWin(Frame parent, int year, int mon) {
      super(parent, "MCalendar " + MCalendar.getMonthName(mon) + " " + 
	    (year+1900), false);
      setLayout(new BorderLayout());
      add("Center", new Effect3D(new MonthCal(year, mon), 
				 Effect3D.RAISED_BORDER));
      
      Panel p = new Panel();
      p.add(new Button("Dismiss"));
      add("South", p);
   }
   
   public boolean action(Event e, Object arg) {
      if(e.target instanceof Button && arg.equals("Dismiss")) {
	 hide();
      }
      return false;
   }
}

class ToDo extends Panel {
   public ToDo() {
      setLayout(new BorderLayout());
      
      String rheader[] = {"8:00am", "8:30", "9:00", "9:30", "10:00", 
			  "10:30", "11:00", "11:30", "12:00pm", "12:30",
			  "1:00", "1:30", "2:00", "2:30", "3:00", 
			  "3:30", "4:00", "4:30", "5:00", "5:30",
			  "6:00", "6:30", "7:00", "7:30", "8:00"};
      String cheader[] = {"To Do"};
      table = new TextGrid(rheader.length, cheader.length, 40, 1);
      table.setEditable(true);
      
      Scroller scrolled = new Scroller(table, true, 150, 200);
      //add("Center", scrolled);
      add("Center", new Effect3D(scrolled, Effect3D.RAISED_BORDER));
      table.setRowHeader(rheader);
      table.setColHeader(cheader);
      
      // use Grid as a layout panel.
      Panel p = new Panel();
      p.setLayout(new BorderLayout());
      Grid gd = new Grid(3, 1);
      p.add("North", gd);
      int row = 0;
      Date today = new Date();
      gd.setRuling(Grid.NONE);
      
      cal = new MCalendar();
      gd.setCell(row++, 0, cal);
      cal.select(today.getDate());
      
      String mon[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		      "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
      month = new Spinner(mon);
      month.setCurrent(today.getMonth());
      gd.setCell(row++, 0, month);
      
      year = new Spinner(1990, 2010);
      year.setCurrent(today.getYear() + 1900);
      gd.setCell(row++, 0, year);
      
      add("West", p);
   }
   
   public boolean action(Event e, Object arg) {
      if(e.target instanceof MCalendar) {
      }
      else if(e.target instanceof Spinner) {
	 if(e.target == month) {
	    cal.setMonth(month.getCurrent());
	 }
	 else if(e.target == year) {
	    cal.setYear(year.getCurrent() - 1900);
	 }
      }
      return true;
   }
   
   Spinner month, year;
   MCalendar cal;
   TextGrid table;
}

class Notes extends Panel {
}

class Address extends Panel {
   public Address() {
      setLayout(new BorderLayout());
      
      String header[] = {"First Name", "Last Name", "Phone", "Department"};
      ml = new MultiList(4, 15);
      ml.setTitle(header);
      add("Center", new Effect3D(ml, Effect3D.LOWERED));
      
      Panel p = new Panel();
      p.add(new Button("Add"));
      p.add(new Button("Modify"));
      p.add(new Button("Delete"));
      add("North", p);
   }
   
   public boolean action(Event e, Object arg) {
      if(e.target instanceof Button) {
	 if(arg.equals("Add")) {
	    AddressEntryWin win = new AddressEntryWin(ml, true);
	    win.pack();
	    win.show();
	 }
	 else if(arg.equals("Modify")) {
	    AddressEntryWin win = new AddressEntryWin(ml, false);
	    win.pack();
	    win.show();
	 }
	 else if(arg.equals("Delete")) {
	    ml.removeRow(ml.getSelectedRow());
	 }
      }
      
      return true;
   }
   
   MultiList ml;
}

class AddressEntryWin extends Frame {
   public AddressEntryWin(MultiList list, boolean newrow) {
      super("Address Entry Window");
      setLayout(new BorderLayout(2, 5));
      this.ml = list;
      this.newrow = newrow;
      
      String row[] = {"", "", "", ""};
      if(!newrow) {
	 int r = ml.getSelectedRow();
	 if(r >= 0) {
	    row = ml.getRow(ml.getSelectedRow());
	 }
      }
      
      add("North", new Shade(new Label("Phone Record:")));
      
      grid = new Grid(4, 2);
      grid.setRuling(Grid.NONE);
      grid.set3D(Grid.LOWERED);
      grid.setGap(Grid.ALL_CELL, Grid.ALL_CELL, new Insets(10, 2, 10, 2));
      grid.setCell(0, 0, new Label("First Name"));
      grid.setCell(1, 0, new Label("Last Name"));
      grid.setCell(2, 0, new Label("Phone"));
      grid.setCell(3, 0, new Label("Department"));
      grid.setCell(0, 1, new Effect3D(new Cell(row[0], 20), 
				      Effect3D.LOWERED));
      grid.setCell(1, 1, new Effect3D(new Cell(row[1], 20), 
				      Effect3D.LOWERED));
      MaskText mt = new MaskText("([999]) [999]-[9999]");
      if(row[2].length() > 0) {
	 mt.setText(row[2]);
      }
      grid.setCell(2, 1, new Effect3D(mt, Effect3D.LOWERED));
      
      ListText lt = new ListText(row[3]);
      lt.add("Computer");
      lt.add("Accounting");
      lt.add("Marketing");
      lt.add("Sales");
      lt.add("Personnel");
      lt.add("Legal");
      lt.setForce(true);
      grid.setCell(3, 1, new Effect3D(lt, Effect3D.LOWERED));
      add("Center", grid);
      
      Panel p = new Panel();
      p.add(new Button("OK"));
      p.add(new Button("Cancel"));
      add("South", p);
   }
   
   public boolean action(Event e, Object arg) {
      if(e.target instanceof Button) {
	 if(arg.equals("OK")) {
	    String[] row = new String[4];
	    for(int i = 0; i < row.length; i++) {
	       Effect3D e3 = (Effect3D) grid.getCell(i, 1);
	       TextEdit cell = (TextEdit) e3.getComponent(0);
	       row[i] = cell.getText();
	    }
	    
	    int r = ml.getSelectedRow();
	    if(r >= 0 && !newrow) {
	       ml.setRow(row, r);
	    }
	    else {
	       ml.addRow(row);
	    }
	    
	    dispose();
	 }
	 else if(arg.equals("Cancel")) {
	    dispose();
	 }
      }
      
      return true;
   }
   
   Grid grid;
   boolean newrow;
   MultiList ml;
}
