/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.ListText to build a
 * simple data entry form with data validation.
 *
 * @see ListText
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class ListEntry extends Applet {
   public void init() {
      ListText lt;
      
      lt = new ListText(20);
      lt.add("New York");
      lt.add("Boston");
      lt.add("Orlando");
      lt.add("Chicago");
      lt.add("New Orlean");
      lt.add("Los Angles");
      lt.add("Bay Area");
      lt.add("Murray Hill");
      
      add(new Label("City:"));
      add(new Effect3D(lt, Effect3D.LOWERED, 1));
      
      lt = new ListText(2);
      lt.setForce(true);
      lt.add("NY");
      lt.add("MA");
      lt.add("FL");
      lt.add("IL");
      lt.add("CA");
      lt.add("PA");
      lt.add("NJ");
      
      add(new Label("State:"));
      add(new Effect3D(lt, Effect3D.LOWERED, 1));
   }
}
