/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.ComboBox to build a
 * simple data entry form with data validation.
 *
 * @see ComboBox
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class ComboEntry extends Applet {
   public void init() {
      ComboBox cb;
      
      cb = new ComboBox(20);
      cb.add("New York");
      cb.add("Boston");
      cb.add("Orlando");
      cb.add("Chicago");
      cb.add("New Orlean");
      cb.add("Los Angles");
      cb.add("Bay Area");
      cb.add("Murray Hill");
      
      add(new Label("City:"));
      add(new Effect3D(cb, Effect3D.LOWERED, 1));
      
      cb = new ComboBox(2);
      cb.setForce(true);
      cb.add("NY");
      cb.add("MA");
      cb.add("FL");
      cb.add("IL");
      cb.add("CA");
      cb.add("PA");
      cb.add("NJ");
      
      add(new Label("State:"));
      add(new Effect3D(cb, Effect3D.LOWERED, 1));
   }
}
