/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.MCalendar.
 *
 * @see MCalendar
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class CalDemo extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      final MCalendar cal = new MCalendar(96, 9);
      
      cal.setTitle(MCalendar.ALL);
      cal.highlight(14);
      cal.select(14, 20);
      
      add("Center", cal);
      
      cal.addActionListener(new ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	    System.out.println(cal.getStartDay());
	    System.out.println(cal.getEndDay());
	 }
      });
   }
}
