{********************************}
{ RealSoft Public Domain Library }
{ Misc procedures and functions. }
{        ---------------         }
{  More at: www.realsoftdev.com  }
{********************************}

unit Realproc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TCharSet = set of Char;

  {* Misc Routines *}
  function  MsgToStr( WM : word ) : String;
  function  HextoInt(Hex : String) : Word;
  function  IntToState( val : word ) : String;
  function  IsDelphiRunning : boolean;
  {* String Routines *}
  function  Pad(S: string; I: smallint): string;
  function  ReplaceAll( old, new, S : String; caseSen : boolean) : string;
  function  ColFormat( Sub, Source : String; Index : smallint) : String;
  function  ColFormatNorm( Sub, Source : String; Index : smallint) : String;
  {* Parsing Routines *}
  procedure Tokenize(S: String; List : TStrings);
  function  GetToken(S: String; token : smallint) : String;
  function  GetPrevToken(S: String; P: byte; C: TCharSet): string;
  function  GetNextToken(S: String; P: byte; C: TCharSet): string;
  function  CasePos(Sub, S : string): smallint;
  function  SinglePos(Sub, S: String; B,A: TCharSet): smallint;
  function  CasePosFromPos(Sub, S : string; Index : smallint): smallint;
  function  PosFromPos(Sub, S : string; Index : smallint): smallint;
  {* File Routines *}
  procedure LoadDFM( filename : String; Dest : TStrings );
  procedure SaveDFM( filename : String; Src : TStrings );
  procedure MkTree( Path : String );
  {* Numeric Routines *}
  function  Pow( base, expon : double ) : double;
  function  Pow10(n: Double): Double;
  function  TrueRound(number : extended; decimals : smallint) : extended;

implementation

{* Misc Routines *}

function MsgToStr( WM : word ) : String;
begin
  case WM of
    WM_ACTIVATE              : result:= 'WM_ACTIVATE             ';
    WM_ACTIVATEAPP           : result:= 'WM_ACTIVATEAPP          ';
    WM_ASKCBFORMATNAME       : result:= 'WM_ASKCBFORMATNAME      ';
    WM_CANCELMODE            : result:= 'WM_CANCELMODE           ';
    WM_CHANGECBCHAIN         : result:= 'WM_CHANGECBCHAIN        ';
    WM_CHAR                  : result:= 'WM_CHAR                 ';
    WM_CHARTOITEM            : result:= 'WM_CHARTOITEM           ';
    WM_CHILDACTIVATE         : result:= 'WM_CHILDACTIVATE        ';
    WM_CLEAR                 : result:= 'WM_CLEAR                ';
    WM_CLOSE                 : result:= 'WM_CLOSE                ';
    WM_COMMAND               : result:= 'WM_COMMAND              ';
    WM_COMMNOTIFY            : result:= 'WM_COMMNOTIFY           ';
    WM_COMPACTING            : result:= 'WM_COMPACTING           ';
    WM_COMPAREITEM           : result:= 'WM_COMPAREITEM          ';
    WM_COPY                  : result:= 'WM_COPY                 ';
    WM_CREATE                : result:= 'WM_CREATE               ';
    WM_CTLCOLOR              : result:= 'WM_CTLCOLOR             ';
    WM_CUT                   : result:= 'WM_CUT                  ';
    WM_DDE_ACK               : result:= 'WM_DDE_ACK              ';
    WM_DDE_ADVISE            : result:= 'WM_DDE_ADVISE           ';
    WM_DDE_DATA              : result:= 'WM_DDE_DATA             ';
    WM_DDE_EXECUTE           : result:= 'WM_DDE_EXECUTE          ';
    WM_DDE_INITIATE          : result:= 'WM_DDE_INITIATE         ';
    WM_DDE_POKE              : result:= 'WM_DDE_POKE             ';
    WM_DDE_REQUEST           : result:= 'WM_DDE_REQUEST          ';
    WM_DDE_TERMINATE         : result:= 'WM_DDE_TERMINATE        ';
    WM_DDE_UNADVISE          : result:= 'WM_DDE_UNADVISE         ';
    WM_DEADCHAR              : result:= 'WM_DEADCHAR             ';
    WM_DELETEITEM            : result:= 'WM_DELETEITEM           ';
    WM_DESTROY               : result:= 'WM_DESTROY              ';
    WM_DESTROYCLIPBOARD      : result:= 'WM_DESTROYCLIPBOARD     ';
    WM_DEVMODECHANGE         : result:= 'WM_DEVMODECHANGE        ';
    WM_DRAWCLIPBOARD         : result:= 'WM_DRAWCLIPBOARD        ';
    WM_DRAWITEM              : result:= 'WM_DRAWITEM             ';
    WM_DROPFILES             : result:= 'WM_DROPFILES            ';
    WM_ENABLE                : result:= 'WM_ENABLE               ';
    WM_ENDSESSION            : result:= 'WM_ENDSESSION           ';
    WM_ENTERIDLE             : result:= 'WM_ENTERIDLE            ';
    WM_ERASEBKGND            : result:= 'WM_ERASEBKGND           ';
    WM_FONTCHANGE            : result:= 'WM_FONTCHANGE           ';
    WM_GETDLGCODE            : result:= 'WM_GETDLGCODE           ';
    WM_GETFONT               : result:= 'WM_GETFONT              ';
    WM_GETMINMAXINFO         : result:= 'WM_GETMINMAXINFO        ';
    WM_GETTEXT               : result:= 'WM_GETTEXT              ';
    WM_GETTEXTLENGTH         : result:= 'WM_GETTEXTLENGTH        ';
    WM_HSCROLL               : result:= 'WM_HSCROLL              ';
    WM_HSCROLLCLIPBOARD      : result:= 'WM_HSCROLLCLIPBOARD     ';
    WM_ICONERASEBKGND        : result:= 'WM_ICONERASEBKGND       ';
    WM_INITDIALOG            : result:= 'WM_INITDIALOG           ';
    WM_INITMENU              : result:= 'WM_INITMENU             ';
    WM_INITMENUPOPUP         : result:= 'WM_INITMENUPOPUP        ';
    WM_KEYDOWN               : result:= 'WM_KEYDOWN              ';
    WM_KEYUP                 : result:= 'WM_KEYUP                ';
    WM_KILLFOCUS             : result:= 'WM_KILLFOCUS            ';
    WM_LBUTTONDBLCLK         : result:= 'WM_LBUTTONDBLCLK        ';
    WM_LBUTTONDOWN           : result:= 'WM_LBUTTONDOWN          ';
    WM_LBUTTONUP             : result:= 'WM_LBUTTONUP            ';
    WM_MBUTTONDBLCLK         : result:= 'WM_MBUTTONDBLCLK        ';
    WM_MBUTTONDOWN           : result:= 'WM_MBUTTONDOWN          ';
    WM_MBUTTONUP             : result:= 'WM_MBUTTONUP            ';
    WM_MDIACTIVATE           : result:= 'WM_MDIACTIVATE          ';
    WM_MDICASCADE            : result:= 'WM_MDICASCADE           ';
    WM_MDICREATE             : result:= 'WM_MDICREATE            ';
    WM_MDIDESTROY            : result:= 'WM_MDIDESTROY           ';
    WM_MDIGETACTIVE          : result:= 'WM_MDIGETACTIVE         ';
    WM_MDIICONARRANGE        : result:= 'WM_MDIICONARRANGE       ';
    WM_MDIMAXIMIZE           : result:= 'WM_MDIMAXIMIZE          ';
    WM_MDINEXT               : result:= 'WM_MDINEXT              ';
    WM_MDIRESTORE            : result:= 'WM_MDIRESTORE           ';
    WM_MDISETMENU            : result:= 'WM_MDISETMENU           ';
    WM_MDITILE               : result:= 'WM_MDITILE              ';
    WM_MEASUREITEM           : result:= 'WM_MEASUREITEM          ';
    WM_MENUCHAR              : result:= 'WM_MENUCHAR             ';
    WM_MENUSELECT            : result:= 'WM_MENUSELECT           ';
    WM_MOUSEACTIVATE         : result:= 'WM_MOUSEACTIVATE        ';
    WM_MOUSEMOVE             : result:= 'WM_MOUSEMOVE            ';
    WM_MOVE                  : result:= 'WM_MOVE                 ';
    WM_NCACTIVATE            : result:= 'WM_NCACTIVATE           ';
    WM_NCCALCSIZE            : result:= 'WM_NCCALCSIZE           ';
    WM_NCCREATE              : result:= 'WM_NCCREATE             ';
    WM_NCDESTROY             : result:= 'WM_NCDESTROY            ';
    WM_NCHITTEST             : result:= 'WM_NCHITTEST            ';
    WM_NCLBUTTONDBLCLK       : result:= 'WM_NCLBUTTONDBLCLK      ';
    WM_NCLBUTTONDOWN         : result:= 'WM_NCLBUTTONDOWN        ';
    WM_NCLBUTTONUP           : result:= 'WM_NCLBUTTONUP          ';
    WM_NCMBUTTONDBLCLK       : result:= 'WM_NCMBUTTONDBLCLK      ';
    WM_NCMBUTTONDOWN         : result:= 'WM_NCMBUTTONDOWN        ';
    WM_NCMBUTTONUP           : result:= 'WM_NCMBUTTONUP          ';
    WM_NCMOUSEMOVE           : result:= 'WM_NCMOUSEMOVE          ';
    WM_NCPAINT               : result:= 'WM_NCPAINT              ';
    WM_NCRBUTTONDBLCLK       : result:= 'WM_NCRBUTTONDBLCLK      ';
    WM_NCRBUTTONDOWN         : result:= 'WM_NCRBUTTONDOWN        ';
    WM_NCRBUTTONUP           : result:= 'WM_NCRBUTTONUP          ';
    WM_NEXTDLGCTL            : result:= 'WM_NEXTDLGCTL           ';
    WM_PAINT                 : result:= 'WM_PAINT                ';
    WM_PAINTCLIPBOARD        : result:= 'WM_PAINTCLIPBOARD       ';
    WM_PALETTECHANGED        : result:= 'WM_PALETTECHANGED       ';
    WM_PALETTEISCHANGING     : result:= 'WM_PALETTEISCHANGING    ';
    WM_PARENTNOTIFY          : result:= 'WM_PARENTNOTIFY         ';
    WM_PASTE                 : result:= 'WM_PASTE                ';
    WM_POWER                 : result:= 'WM_POWER                ';
    WM_QUERYDRAGICON         : result:= 'WM_QUERYDRAGICON        ';
    WM_QUERYENDSESSION       : result:= 'WM_QUERYENDSESSION      ';
    WM_QUERYNEWPALETTE       : result:= 'WM_QUERYNEWPALETTE      ';
    WM_QUERYOPEN             : result:= 'WM_QUERYOPEN            ';
    WM_QUEUESYNC             : result:= 'WM_QUEUESYNC            ';
    WM_QUIT                  : result:= 'WM_QUIT                 ';
    WM_RBUTTONDBLCLK         : result:= 'WM_RBUTTONDBLCLK        ';
    WM_RBUTTONDOWN           : result:= 'WM_RBUTTONDOWN          ';
    WM_RBUTTONUP             : result:= 'WM_RBUTTONUP            ';
    WM_RENDERALLFORMATS      : result:= 'WM_RENDERALLFORMATS     ';
    WM_RENDERFORMAT          : result:= 'WM_RENDERFORMAT         ';
    WM_SETCURSOR             : result:= 'WM_SETCURSOR            ';
    WM_SETFOCUS              : result:= 'WM_SETFOCUS             ';
    WM_SETFONT               : result:= 'WM_SETFONT              ';
    WM_SETREDRAW             : result:= 'WM_SETREDRAW            ';
    WM_SETTEXT               : result:= 'WM_SETTEXT              ';
    WM_SHOWWINDOW            : result:= 'WM_SHOWWINDOW           ';
    WM_SIZE                  : result:= 'WM_SIZE                 ';
    WM_SIZECLIPBOARD         : result:= 'WM_SIZECLIPBOARD        ';
    WM_SPOOLERSTATUS         : result:= 'WM_SPOOLERSTATUS        ';
    WM_SYSCHAR               : result:= 'WM_SYSCHAR              ';
    WM_SYSCOLORCHANGE        : result:= 'WM_SYSCOLORCHANGE       ';
    WM_SYSCOMMAND            : result:= 'WM_SYSCOMMAND           ';
    WM_SYSDEADCHAR           : result:= 'WM_SYSDEADCHAR          ';
    WM_SYSKEYDOWN            : result:= 'WM_SYSKEYDOWN           ';
    WM_SYSKEYUP              : result:= 'WM_SYSKEYUP             ';
    WM_SYSTEMERROR           : result:= 'WM_SYSTEMERROR          ';
    WM_TIMECHANGE            : result:= 'WM_TIMECHANGE           ';
    WM_TIMER                 : result:= 'WM_TIMER                ';
    WM_UNDO                  : result:= 'WM_UNDO                 ';
    WM_USER                  : result:= 'WM_USER                 ';
    WM_VKEYTOITEM            : result:= 'WM_VKEYTOITEM           ';
    WM_VSCROLL               : result:= 'WM_VSCROLL              ';
    WM_VSCROLLCLIPBOARD      : result:= 'WM_VSCROLLCLIPBOARD     ';
    WM_WINDOWPOSCHANGED      : result:= 'WM_WINDOWPOSCHANGED     ';
    WM_WINDOWPOSCHANGING     : result:= 'WM_WINDOWPOSCHANGING    ';
    WM_WININICHANGE          : result:= 'WM_WININICHANGE         ';
    else result:= 'UNKNOWN: '+inttostr(wm);
    end;
end;

function HextoInt(Hex : String) : Word;
var
  i : byte;
  e : longint;
  function ZeroToF(c : char) : byte;
  begin
    case c of
      '0' : result:= 0;
      '1' : result:= 1;
      '2' : result:= 2;
      '3' : result:= 3;
      '4' : result:= 4;
      '5' : result:= 5;
      '6' : result:= 6;
      '7' : result:= 7;
      '8' : result:= 8;
      '9' : result:= 9;
      'a','A' : result:= 10;
      'b','B' : result:= 11;
      'c','C' : result:= 12;
      'd','D' : result:= 13;
      'e','E' : result:= 14;
      'f','F' : result:= 15;
      else result:= 0;
      end;
  end;
begin
  result:= 0; e:= 1;
  for i:= length(Hex) downto 1 do begin
    result:= result + ZeroToF(Hex[i])*e;
    e:= e * 16;
    end;
end;

function IntToState( val : word ) : String;
begin
  case Val of
    1:  result:= 'AK';
    2:  result:= 'AL';
    3:  result:= 'AR';
    4:  result:= 'AZ';
    5:  result:= 'CA';
    6:  result:= 'CO';
    7:  result:= 'CT';
    8:  result:= 'DC';
    9:  result:= 'DE';
   10:  result:= 'FL';
   11:  result:= 'GA';
   12:  result:= 'HI';
   13:  result:= 'IA';
   14:  result:= 'ID';
   15:  result:= 'IL';
   16:  result:= 'IN';
   17:  result:= 'KS';
   18:  result:= 'KY';
   19:  result:= 'LA';
   20:  result:= 'MA';
   21:  result:= 'MD';
   22:  result:= 'ME';
   23:  result:= 'MI';
   24:  result:= 'MN';
   25:  result:= 'MO';
   26:  result:= 'MS';
   27:  result:= 'MT';
   28:  result:= 'NC';
   29:  result:= 'ND';
   30:  result:= 'NE';
   31:  result:= 'NH';
   32:  result:= 'NJ';
   33:  result:= 'NV';
   34:  result:= 'NY';
   35:  result:= 'OH';
   36:  result:= 'OK';
   37:  result:= 'OR';
   38:  result:= 'PA';
   39:  result:= 'RI';
   40:  result:= 'SC';
   41:  result:= 'SD';
   42:  result:= 'TN';
   43:  result:= 'TX';
   44:  result:= 'UT';
   45:  result:= 'VA';
   46:  result:= 'VT';
   47:  result:= 'WA';
   48:  result:= 'WI';
   49:  result:= 'WV';
   50:  result:= 'WY';
   else result:= '??';
   end;
end;

function IsDelphiRunning : boolean;
begin
  if((FindWindow('TApplication','Delphi') = 0) and (FindWindow('TApplication','Delphi 2.0') = 0) ) or
    (FindWindow('TPropertyInspector',nil) = 0) or
    (FindWindow('TAppBuilder',nil) = 0) then result:= false
  else result:= true;
end;

{* String Routines *}

function Pad(S: string; I: smallint): string;
var x: byte;
begin
  result:= S;
  if I <= Length(S) then Exit;
  for x:= Length(S) to I-1 do result:= result + ' ';
end;

function ReplaceAll( Old, New, S : String; caseSen : boolean ) : string;
var
  P,x : smallint;
  tmpstr : String;
begin
  P:= 1;
  if not caseSen then Old:= AnsiLowerCase(Old);
  while P < length(S) do begin
    tmpstr:= Copy(S, P, length(S)-P+1);
    if not caseSen then tmpstr:= AnsiLowerCase(tmpstr);
    x:= Pos(Old, tmpstr);
    if x > 0 then begin
      Delete(S, P+x-1, length(Old));
      Insert(New, S, P+x-1);
      P:= P + x - 1 + length(new);
      end
    else inc(P);
    end;
  Result:= S;
end;

function ColFormat( Sub, Source : String; Index : smallint) : String;
var
  tmpstr : String;
  i      : smallint;
begin
  for i:= 0 to 120 do tmpstr[i]:= #32;
  tmpstr[0]:= #120;
  Insert( Source, tmpstr, 1 );
  Insert( Sub, tmpstr, index - length(sub) );
  result:= tmpstr;
end;

function ColFormatNorm( Sub, Source : String; Index : smallint) : String;
var
  S : String;
  i      : smallint;
begin
  for i:= 0 to 120 do S[i]:= #32;
  S[0]:= #120;
  Insert( Source, S, 1 );
  Insert( Sub, S, index );
  if length(S) > 120 then S[0]:= #120;
  result:= S;
end;

{* Parsing Routines *}

procedure Tokenize(S: String; List : TStrings);
var
  P,L : smallint;
  tmpstr : String;
begin
  List.Clear;
  L:= 1;
  for P:= 1 to Length(S) do begin
    if (S[P] = ',') or (P = Length(S)) then begin
      if P = L then tmpstr:= ''
      else tmpstr:= Copy(S, L, P-L);
      List.Add(tmpstr);
      L:= P+1;
      end;
    end;
  if S[Length(S)] = ',' then List.Add('');
end;

function GetToken(S: String; token : smallint) : String;
var
  L, P, t : smallint;
begin
  result:= '';
  t:= 0;
  L:= 1;
  for P:= 1 to Length(S) do begin
    if (S[P] = ',') or (P = Length(S)) then begin
      inc(t);
      if t = token then begin
        if P = Length(S) then Result:= Copy(S, L, P-L+1)
        else Result:= Copy(S, L, P-L);
        Break;
        end;
      L:= P+1;
      end;
    end;
end;

function PosFromPos(Sub, S : string; Index : smallint): smallint;
var
  x      : smallint;
  tmpstr : string;
begin
  if index < length(S) - length(sub) + 1 then begin
    tmpstr:= copy(S, Index, (length(s) - Index) + 1);
    if length(Sub) < length(tmpstr) then begin
      x:= Pos(Sub, tmpstr);
      if x > 0 then result:= (Index + x) - 1
      else result:= -1;
      end
    else result:= -1;
    end
  else result:= -1;
end;

function CasePos(Sub, S : string): smallint;
begin
  Sub:= Lowercase(Sub);
  S:= Lowercase(S);
  Result:= Pos(Sub,S);
end;

function SinglePos(Sub, S: String; B,A: TCharSet): smallint;
var P : smallint;
begin
  Sub:= Lowercase(Sub);
  S:= Lowercase(S);
  Result:= 0;
  P:= CasePos(Sub,S);
  if P > 0 then begin
    if P > 1 then
      if not (S[p-1] in B) then Exit;
    if P + length(Sub) -1 < length(s) then
      if not (S[p + Length(Sub)] in A) then Exit;
   end;
  Result:= P;
end;

function CasePosFromPos(Sub, S : string; Index : smallint): smallint;
var
  x      : smallint;
  tmpstr : string;
begin
  Sub:= Lowercase(Sub);
  S:= Lowercase(S);
  if index < length(S) - length(sub) + 1 then begin
    tmpstr:= copy(S, Index, (length(s) - Index) + 1);
    if length(Sub) < length(tmpstr) then begin
      x:= CasePos(Sub, tmpstr);
      if x > 0 then result:= (Index + x) - 1
      else result:= 0;
      end
    else result:= 0;
    end
  else result:= 0;
end;

function GetPrevToken(S: String; P: byte; C: TCharSet): string;
var x,endpos: byte;
begin
  endpos:= 0;
  for x:= P downto 1 do begin
    if endpos = 0 then
      if (S[x] in C) then endpos:= x;
    if endpos > 0 then
      if not (S[x] in C) then begin inc(x); break; end;
    end;
  if (endpos >= x) and (endpos > 0) then result:= Copy(S, x, endpos-x+1)
  else result:= '';
end;

function GetNextToken(S: String; P: byte; C: TCharSet): string;
var x,begpos: byte;
begin
  begpos:= 0;
  for x:= P to length(S) do begin
    if begpos = 0 then
      if (S[x] in C) then begpos:= x;
    if begpos > 0 then
      if not (S[x] in C) then begin inc(x); break; end;
    end;
  if (x >= begpos) and (begpos > 0) then result:= Copy(S, begpos, x-begpos-1)
  else result:= '';
end;

{* File Routines *}

procedure MkTree( Path : String );
var
  tmpstr : String;
  olddir : String;
  drive  : String;
  x,s    : smallint;
begin
  {check for drive letter at beginning}
  if Path[1] = '\' then s:= 2
  else s:= 4;
  {create dir + subdirs}
  for x:= s to Length(Path) do begin
    if Path[x] = '\' then begin
      tmpstr:= Copy( Path, 1, x-1 );
      {$I-}
      MkDir(tmpstr);
      {$I+}
      end;
    end;
end;

procedure LoadDFM( filename : String; Dest : TStrings );
var
  InStream  : TFileStream;
  OutStream : TMemoryStream;
begin
  InStream  := TFileStream.Create( filename, fmOpenReadWrite );
  OutStream := TMemoryStream.Create;
  ObjectResourceToText( InStream, OutStream );
  InStream.Free;
  OutStream.Seek(0,0);
  Dest.LoadFromStream( OutStream );
  OutStream.Free;
end;

procedure SaveDFM( filename : String; Src : TStrings );
var
  OutStream  : TFileStream;
  InStream   : TMemoryStream;
begin
  InStream := TMemoryStream.Create;
  OutStream  := TFileStream.Create( filename, fmCreate );
  Src.SavetoStream(InStream);
  InStream.Seek(0,0);
  ObjectTextToResource( InStream, OutStream );
  InStream.Free;
  OutStream.Free;
end;

{* Numeric Routines *}

function Pow( base, expon : double ) : double;
begin
  Result:= Exp(expon*(ln(base)));
end;

function Pow10(n: Double): Double;
begin
  Result:=Exp(n * Ln(10));
end;

function TrueRound(number : extended; decimals : smallint) : extended;
begin
  number := number * pow10(decimals);
  number := round(number);
  number := number / pow10(decimals);
  result:= number;
end;


end.
