Why REXX Code Formatter/2
-------------------------

There are three important reasons why RCF/2 was developed:

(1) All programmers, novice or professional, develop a style of coding
    that they like to use when writing a program.  Often times, however, 
    in the haste to complete a program, or simply because they are 
    concentrating on the logic and not the format, the style used is not
    always consistent. For example, comments are not aligned alike for
    easier reading and statements under a DO or SELECT are not properly
    or consistently indented.

(2) Some programs are inherited and some contain code that was included
    from another source.  In both cases, the style is often different, 
    and in some instances, very different from that used by the person
    maintaining the code.  A program with the END statement aligned with
    the other code under a DO statement is very difficult to maintain by
    a programmer used to having the END align with the DO statement,
    itself.

(3) Finally, when a person has completed a program and wants to turn it
    over to maintenance, give it to the customer for whom it was done, or
    simply show to others, there is a natural desire, if not a need, to 
    make it neat, consistent, and professional looking.  Even the best of
    programs can look a bit sloppy if functions and REXX keywords are
    sometimes in one case and sometimes in another.

Time does not always allow programmers to go back over their work to
"clean" it up, and even when there is time, the task, by its nature, is a
very boring one, and all inconsistencies are seldom removed.

The purpose of REXX Code Formatter/2 is to handle this formatting chore
for the programmer.


Features of REXX Code Formatter/2
---------------------------------

Using this product, users may, among other things:

   Define the indentation to be used in general plus the amount for: 
    - Program statements subordinate to DO and SELECT,
    - Statements that begin with THEN/ELSE, and 
    - Continued statements.
   Specify whether:
    - Lines are to be split at semicolons,
    - Redundant spaces are to be removed from program statements,
    - New lines are to start before or after THEN/ELSE keywords, and
    - END statements are to be indented to align with the corresponding 
      DO/SELECT subordinate statements.
   Specify the formatting for:
    - REXX keyword Instructions,
    - REXX keywords besides those that begin a REXX keyword instruction,
    - Variables names,
    - Function names, and
    - Labels.
   Define special formatting for selected function names.
   Check for duplicate labels and insure all labels start on a new line.
   Have RCF/2 create a file of label names as they appear in the program
    so that all references to them in the program (and even other
    programs) will reflect this same format.
   Align full-line, left-hand, and right-hand comments.
   Generate a listing of the formatted program.

In addition, while RCF/2 is not a syntax-checker or code debugger, it 
does provide some assistance in program development.  It can, for example:

   Identify DO and SELECT instructions missing a corresponding END clause,
   Flag comments that are started but not closed, and
   Highlight literal strings with a missing quote.

