/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termctl.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
#else
	#include "pblibc.h"
#endif

/*
 * a v a t a r   t e r m i n a l   i m p l e m e n t a t i o n
 * 
 * this is the implementation of the avatar control sequence class
*/
void
avatar_ctrl::set_fg(int fore)
{
	char buf[10];

	term_ctrl::set_fg(fore);
	sprintf(buf, "\026\001%c", char((get_bg() << 4) | fore));
	put(buf, strlen(buf));
}

void
avatar_ctrl::set_bg(int back)
{
	char buf[10];

	term_ctrl::set_bg(back);
	if( back & 0x08 ) put("\026\002", 2);
	sprintf(buf, "\026\001%c", (char)(((back & 0x07)<<4)|get_fg()));
	put(buf, strlen(buf));
}

void
avatar_ctrl::set_color(int attrib)
{
	char buf[10];

	term_ctrl::set_color(attrib);
	if( get_bg() & 0x08 ) put("\026\002", 2);
	sprintf(buf, "\026\001%c", attrib & 0x7f);
	put(buf, strlen(buf));
}

void
avatar_ctrl::clr_scr()
{
	term_ctrl::clr_scr();
	put(12); // ^L
}

void
avatar_ctrl::clr_eol()
{
	term_ctrl::clr_eol();
	put("\026\007", 2); // ^V^G
}

void
avatar_ctrl::cursor_xy(int x, int y)
{
	char buf[15];

	term_ctrl::cursor_xy(x, y);
	sprintf(buf, "\026\010%c%c", (char)y, (char)x);
	put(buf, strlen(buf));
}

void
avatar_ctrl::cursor_up(int rows)
{
	while( 0 < rows-- )
	{
		if( 0 >= get_y() ) break;
		term_ctrl::cursor_up(1);
		put("\026\003", 2);
	}
}

void
avatar_ctrl::cursor_down(int rows)
{
	while( 0 < rows-- )
	{
		if( 25 <= get_y() ) break;
		term_ctrl::cursor_down(1);
		put("\026\004", 2);
	}
}

void
avatar_ctrl::cursor_left(int columns)
{
	while( 0 < columns-- )
	{
		if( 0 >= get_x() ) break;
		term_ctrl::cursor_left(1);
		put("\026\005", 2);
	}
}

void
avatar_ctrl::cursor_right(int columns)
{
	while( 0 < columns-- )
	{
		if( 80 <= get_x() ) break;
		term_ctrl::cursor_right(1);
		put("\026\006", 2);
	}
}

