/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include <time.h>
#include <stdio.h>
#include "pblsdk.h"
#include "proboard.h"
#include "utils.h"
#include "file.h"
#include "stdmac.h"
#include "comdef.h"
#include "pbnames.h"

static int adjust_timer = 0;

int
TimeUntilEvent()
{
	EVENT      event;
	int        retval = 0x7fff;
	int        daymask = 0;
	FILE      *fp;
	time_t     timer = time(NULL);
	struct tm *t = localtime(&timer);

	// the day mask is the day of the week shift for the bit
	iSetBit(daymask, (0 == t->tm_wday) ? 6 : t->tm_wday - 1);
	fp = pb_fopen(fnEVENTS, "rb", PBDIR_SYS);
	if( fp ){
		file_read(fp, &event);
		while( !feof(fp) ){
			if( event.enabled && (event.daysEnabled & daymask) &&
				(!event.nodeNum || (event.nodeNum == NodeNumber)))
			{
				int mins = (t->tm_hour - event.startTime[0]) * 60 +
						   (t->tm_min  - event.startTime[1]);
				// only if the event hasn't executed already
				if( mins > 0 ){
					retval = mins;
					break;
				}
			}
			file_read(fp, &event);
		}
		fclose(fp);
	}
	return retval;
}

int
TimeOnline( void )
{
	time_t    timenow = time(NULL), logintime;
	struct tm login;

	login.tm_hour = LoginTime[0];
	login.tm_min  = LoginTime[1];
	login.tm_sec  = LoginTime[2];
	login.tm_mday = LoginDate[0];
	login.tm_mon  = LoginDate[1] - 1;
	login.tm_year = LoginDate[2];

	logintime = mktime(&login);
	return int((timenow - logintime) / 60);
}


int
TimeLeft( void )
{
	int limit = pb_limit(CurUser->level)->timelimit;

	return min(limit, TimeUntilEvent()) - TimeOnline() + adjust_timer;
}

void
AddTime( int plusminus )
{
	adjust_timer = plusminus;
}

