/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef PB_SDK
	#include <stdio.h>
	#include <ctype.h>
	#include <conio.h>
	#include <dos.h>
	#include <assert.h>
	#include <string.h>
	#include <stdlib.h>
	#include "compiler.h"
#endif

/*
 * plays a RA-compatible music file:
 *  0 - played till end, 1 - file not found, >1 hotkey pressed
 * if 'aHotKeys' is 0 (NULL pointer), any key will abort
 * if 'aHotKeys' is "" (empty string), will not be able to abort
*/
char PlayMusic(const char *fileName, const char *aHotKeys)
{
	char  retval = 0;
    char  buf[255], *hotKeys = 0;
	FILE *fp = fopen(fileName, "rt");

    if( !fp ){
    	retval = 1;
	}
    else{
	    while( kbhit() ) getch();			// flush the input buffer

		// only check for hotkeys if there's a list defined
		if( aHotKeys && strlen(aHotKeys) ){
	        hotKeys = strdup(aHotKeys);	// copy the hotkey list
	        assert(hotKeys);			// this can't really happen :-)
	        strupr(hotKeys);			// convert to uppercase
		}

    	setvbuf(fp, NULL, _IOFBF, 0x1000);	// assing a large buffer
		fgets(buf, sizeof(buf), fp);		// priming read

        while( !feof(fp) ){
        	char     *p = buf;
            unsigned  hz, dur;

            if( (hotKeys || !aHotKeys) && kbhit() ){ // check for a hotkey pressed
            	int c = getch();
            	if( !aHotKeys ){
            		retval = 0;
            		goto _ret;
            	}
            	else if( isascii(c) ){			// is this a valid ASCii
	            	p = strchr(hotKeys, toupper(c));
                    if( p ){				// found in the hotkey list
                    	retval = *p;		// store the hotkey
                        goto _ret;			// go and quit the function
					}
                }
			}

            for( p = buf; isspace(*p); ++p )	// skip leading whitespace
            	;

            switch( toupper(*p) ){			// check first letter (faster)
            	case 'T':
                	sscanf(p+4, "%u %u", &hz, &dur);
                    sound(hz);
                    delay(dur * 10);
                    nosound();
                break;
                case 'W':
                	sscanf(p+4, "%u", &dur);
                    delay(dur * 10);
                break;
                default : break;
			}
        	fgets(buf, sizeof(buf), fp);
		}
    _ret:
        fclose(fp);
        free(hotKeys);
	}
    return retval;
}

