/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblsdk.h"
#include "proboard.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
#endif

void
WriteMSGTMP(char *text)
{
	FILE *fp = pb_fopen("MSGTMP", "wb", PBDIR_STARTUP);

	if( fp ){
		fwrite(text, sizeof(char), strlen(text), fp);
		fclose(fp);
	}
}

void
AppendMSGTMP(char *text)
{
	FILE *fp = pb_fopen("MSGTMP", "r+b", PBDIR_STARTUP);

	if( fp ){
		fseek(fp, 0L, SEEK_END);
		fwrite(text, sizeof(char), strlen(text), fp);
		fclose(fp);
	}
}
