/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "profile.h"
#include "str.h"

// reads a variable from ProBoard-style INI file
BOOL
GetIniVar( char *fname, char *var, char *value, int len )
{
	zProfile  profile;
	char     *pbuf;
	BOOL      retval = FALSE;

	profile.Assign( fname );
	profile.Open();
	if( profile ){
		// little trick here. zProfile does not return an error when the
		// variable is not found. we put a value that cannot occur in the
		// return buffer if read from the file (end of line) and check :)
		pbuf = profile.ReadString(0, var, "\n");
		if( '\n' != pbuf[0] ){
			strnecpy(value, pbuf, len);
			retval = TRUE;
		}
		profile.Close();
	}
	return retval;
}

// writes a variable to ProBoard-style INI file.
BOOL
SetIniVar( char *fname, char *var, char *value )
{
	zProfile profile;

	profile.Assign( fname );
	profile.Open();
	if( !profile ) return FALSE;
	if( profile.WriteString(0, var, value) ) return TRUE;
	return FALSE;
}
