/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "parsevar.h"
#include "parsedef.h"
#include "stdmac.h"
#include "str.h"
#include "comdef.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <ctype.h>
#endif

/*
 * p a r s e   *   ( s t a r )   c o d e s
 * 
 * this routine parses all * codes in 'src' and places the new string in
 * 'dest'. it is very similar to parse_macro() except it only works for
 * some of the Function 7 (Shell) optional arguments for the data line.
*/
void
parse_stars(char *dest, char *src, int maxLen)
{
	int  slen = 0;
	char buf[256], *p;
	int  token;

	*dest = EOS;
	if( !src || EOS == *src ) return;

	for( slen = 0; slen < maxLen && EOS != *src; )
	{
		if( '*' == *src && EOS != src[1] )
		{
			token = PDEF_ERROR;
			buf[0] = EOS;

			switch( toupper(src[1]) )
			{
				case '*': *dest++ = '*';             break;
				case '#': token = PDEF_SYS_NODE;     break;
				case 'B': token = PDEF_SYS_BAUD;     break;
				case 'F': token = PDEF_USR_FIRST;    break;
				case 'M': token = PDEF_SYS_STARTUP;  break;
				case 'O': token = PDEF_USR_FAREADIR; break;
				case 'P': token = PDEF_SYS_PORT;     break;
				case 'R': token = PDEF_USR_RECNO;    break;
				case 'S': token = PDEF_SYS_SYSTEM;   break;
				case 'T': token = PDEF_USR_TLEFT;    break;
				case 'L':
					if( 0 != (p = strchr(CurUser->name, ' ')) )
						strcpy(buf, strskpw(p));
					break;
				case 'C': // fall-through to next case
				case 'Z':
					if( 0 != (p = getenv("COMSPEC")) )
					{
						strcpy(buf, p);
						if( 'Z' == toupper(src[1]) ) strcat(buf, " /C");
					}
				break;
				default : // skip over the option
					src += 2;
					continue;
			}

			// we got here, we know what to do now either we have a token
			// to work with or the buffer is not empty, so process both!
			if( EOS != *buf || parse_token(buf, token, PDEF_JUST_LEFT, 0) )
			{
				size_t nChars = min(maxLen - slen, (int)strlen(buf));
				memcpy(dest, buf, nChars);
				dest += nChars;
				slen += nChars;
			}
			src += 2; // skip the code in the src string
		}
		else
		{
			*dest++ = *src++;
			slen++;
		}
	}
	*dest = EOS;
}
