/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "getopt.h"
#include "typedef.h"
#include "stdmac.h"

/*
 * c o m m a n d   l i n e   o p t i o n   p a r s e r
 * 
 * this module implements the standard command line option extracting routine
*/

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
#else
	#include "pblibc.h"
#endif

#define __SWITCH(c) ( '-' == (c) || '/' == (c) )
#define __PRERR(s,c) if( opterr ){ \
	printf( "%s: %s -- '%c'\n", strlwr(argv[0]), (s), (c) );\
}

int   optopt;         /* holds the option character found       */
int   optind = 1;     /* index into the argv array              */
int   opterr = 1;     /* 1 to report errors, 0 to suppress them */
char *optarg;         /* if option takes argument, points to it */

int
getopt( int argc, char *argv[], const char *opts )
{
	static char lastfix = 1;
	char *p;

	/* check for option switch character */
	if( 1 == lastfix )
	{
		if( optind >= argc || !__SWITCH(argv[optind][0]) ||
			EOS == argv[optind][1] )
		{
			return EOF;
		}
		else if( 0 == strcmp( "--", argv[optind] ) )
		{
			optind++;
			return EOF;
		}
	}

	/* see if the option is valid */
	optopt = argv[optind][lastfix];
	if( NULL == (p = (char*)strchr(opts, optopt)) || ':' == optopt )
	{
		__PRERR( "unknown option", optopt );
		optind++;
		lastfix = 1;
		return '?';
	}

	/* see if we want an argument with that option */
	if( *++p == ':' )
	{
		/* any more characters in same arg */
		if( EOS == argv[optind][++lastfix] )
		{
			if( ++optind >= argc )
			{
				__PRERR( "option requires an argument", optopt );
				lastfix = 1;
				return ':';
			}
			optarg = argv[optind];
		}
		else
		{
			optarg = &argv[optind][lastfix];
		}
		optind++;
		lastfix = 1;
	}
	else
	{
		/* if we reached end of string, get next argument */
		if( EOS == argv[optind][++lastfix] )
		{
			optind++;
			lastfix = 1;
		}
		optarg = NULL;
	}

	/* return the option */
	return optopt;
}

#undef __SWITCH
#undef __PRERR
