/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "fbase.h"
#include "grep.h"
#include "pblsdk.h"
#include "proboard.h"
#include "pbnames.h"
#include "file.h"

#ifndef PB_SDK
	#include <string.h>
#endif

zFileIndex::zFileIndex():
	m_init(False)
{
	m_fp = pb_fopen(fnFILESIDX, "rb", PBDIR_SYS);
	if( m_fp ) setvbuf(m_fp, 0, _IOFBF, 0x1000);
}

zFileIndex::~zFileIndex()
{
	if( m_fp ) fclose(m_fp);
}

short
zFileIndex::Find(char *match, const char *pattern)
{
	if( !match || !m_fp )
	{
		m_init = False;
		return 0;
	}

	// we have a new pattern
	if( pattern )
	{
		char buf[255];
		if( -1 == glob_compile(strupr(strcpy(buf, pattern))) )
		{
			m_init = False;
			return 0;
		}
		rewind(m_fp);
		m_init = True;
	}
	// now start searching
	if( m_init )
	{
		FILESIDX irec;

		file_read(m_fp, &irec);
		while( !feof(m_fp) )
		{
			if( EOS != irec.filename[0] && -1 != glob_match(irec.filename) )
			{
				strcpy(match, irec.filename);
				return irec.area;
			}
			file_read(m_fp, &irec);
		}
	}
	return 0;
}
