/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"

#ifndef PB_SDK
	#include <string.h>
	#include <conio.h>
	#include <dos.h>
	#include "compiler.h"
#else
	#include "pblibc.h"
	#include "pblsdk.h"
#endif

/*
 * flashes a light through a string
*/
int   flash_delay = 12;
uchar flash_palette[EFFECT_PALSIZE] = { 8, 7, 15, 7, 8 };

void
effect_flash( char *s, int x, int y )
{
	int slen = strlen(s);
	int skip = EFFECT_PALSIZE / 2 + (EFFECT_PALSIZE & 1);

	textattr( flash_palette[0] );
	gotoxy( x, y );
	cprintf( s );

	/* just skip first half-palette characters... no big deal */
	for( int i = skip; i < slen; ++i )
	{
		for( int j = 0; j < EFFECT_PALSIZE; ++j )
		{
			gotoxy( x + i - j, y );
			textattr( flash_palette[j] );
			putch( s[i - j] );
			delay( flash_delay );
		}
	}

	/* set last three characters to old color */
	textattr( flash_palette[0] );
	gotoxy( x + slen - skip - 1, y );
	cprintf(&s[slen - skip - 1]);
}
