/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "edit.h"
#include "stdmac.h"
#include "comdef.h"

#ifndef PB_SDK
	#include <ctype.h>
	#include <string.h>
#else
	#include "pblibc.h"
#endif

////////////////////////////////////////////////////////////////////////////
// Class to input filenames (or paths) with/without wildcards
////////////////////////////////////////////////////////////////////////////
zEditFile::zEditFile(const zRect &bounds, short aMaxLen, short aOptions):
	zEditLine(bounds, aMaxLen),
    options(aOptions)
{
	if( !(options & edit_options::path) )
	{
		maxLen = min(short(MAXFILE+MAXEXT-2), aMaxLen);
        if( maxLen != aMaxLen )
        {
        	delete[] data;
            data = new char [maxLen + 1];
            *data = EOS;
		}
    }
}

void
zEditFile::handle(ushort aKeyCode)
{
    static const char *notValid = "\"=;+,<>|";	// and isspace() too
    static const char *wildCard = "*?[]";		// these are extended!
    static const char *pathSeps = "\\/:";		// path separators (almost)
    int    code = aKeyCode;

    if( isascii(code) &&
		(isspace(code) ||
		strchr(notValid, code) ||
		(!(options & edit_options::wildcards) && strchr(wildCard, code)) ||
        (!(options & edit_options::path) && strchr(pathSeps, code))) )
    {
    	return;	// invalid character
	}

    // check for one period in filenames and one colon in paths
	if( !(options & edit_options::path) &&
		('.' == code) && strchr(data, '.') )
	{
			return;
	}
    if( (':' == code) && strchr(data, ':') ) return;	// one ':'

    // check to see if the number of characters after period is valid
    // also check for too many characters without a period
    if( !(options & edit_options::path) && isprint(code) )
    {
    	char *p = strchr(data, '.');
        if( p && 4 <= strlen(p) ) return;
        else if( !p && '.' != code && 8 == strlen(data) ) return;
	}

    // see if we want to convert it
    if( (options & edit_options::upper) && isascii(aKeyCode) )
		aKeyCode = toupper(aKeyCode);

    zEditLine::handle(aKeyCode);
}
