/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

int
bioskey(int command)
{
	union REGS regs;

	regs.h.ah = command;
	regs.h.al = 0;
	if( 0 == regs.h.al ) ; // sets the zero flag
	int86(0x16, &regs, &regs);
	// if we have a key and we are not checking status
	if( !(regs.x.flags & 0x40) ){
		if( !(command & 1) ){ // we are reading a key
			if( 0 == regs.x.ax ) regs.x.ax = 0xffff;
		}
	}
	else if( !(command & 1) ) regs.x.ax = 0;  // no key and not status check
	return regs.x.ax;
}
