/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"
#include "utils.h"

#ifndef PB_SDK
	#include <ctype.h>
#else
	#include "pblibc.h"
#endif

/*
 * r e m o t e a c c e s s   c o l o r   i n t e r p r e t e r
 * 
 * this implements the RemoteAccess ^K[color interpreter. it is more or less
 * the same as the hexpipe and proboard color specifications (hex digits)
*/
Boolean
remoteaccess_interp::init( uchar aSOS )
{
	Boolean retval = False;

	if( 0x0b == aSOS )
	{
		term_interp::init(aSOS);
		retval = True;
	}

	return retval;
}

void
remoteaccess_interp::handle( uchar aChar )
{
	// this is the first character after ^K
	if( 1 == m_buff->getCount() )
	{
		m_buff->put(aChar);
		if( '[' != aChar ) m_fail = True;
		return;
	}
	// this is the last character in the sequence
	if( 3 == m_buff->getCount() )
	{
		if( isxdigit(m_buff->bp()[2]) && isxdigit(aChar) )
		{
			m_ctrl->set_color(hexColor(m_buff->bp()[2], aChar));
			m_eos = True;
		}
		else
		{
			m_buff->put(aChar);
			m_fail = True;
		}
	}
	else m_buff->put(aChar);
}

