/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <stdlib.h>
	#include <string.h>
	#include <time.h>
#endif

/*
 * generates a unique name, appends to path argument (local helper function)
*/
static char*
unique( char *path )
{
	char *ends;
	int   retry;

	file_appchr(path, 0);
	ends = &path[strlen(path)];

	for( retry = 0; retry < 200; retry++ ){
		*ends = '\0';
		sprintf( ends, "%08lX.TMP", (unsigned long)time(NULL) + retry );
		if( !file_exist( path ) ) return path;
	}
	return NULL;
}

/*
 * creates a temp filename, returns name (doesn't create file)
*/
char*
file_tempname( void )
{
	static char path[MAXPATH];
	char *ptr;

	ptr = getenv( "TEMP" );
	if( !ptr ) ptr = getenv( "TMP" );
	if( !ptr ) strcpy( path, ".\\" );
	else strcat( strcpy(path, ptr), "\\" );

	return unique( path );
}

/*
 * creates a unique filename for the specified directory, doesn't create file
*/
char*
file_unique( char *path )
{
	static char buf[MAXPATH];

	return unique( strcpy(buf, path) );
}
