/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"

/*
 * local helper function that does the real copying of the file
*/
static int
DoCopy(const char *dest, const char *src, const char *mode)
{
	FILE *sfp, *dfp;
	char buf[0x400];

	if( NULL == (sfp = fopen(src, "rb")) )  return -1;
	if( NULL == (dfp = fopen(dest, mode)) ){
		fclose(sfp);
		return -1;
	}

	if( setvbuf( sfp, NULL, _IOFBF, 0x4000 ) ){
		fclose(sfp);
		fclose(dfp);
		return -1;
	}

	for( ;; ){
		int st = fread( buf, sizeof(char), 0x400, sfp );
		if( 0 == st ) break;
		fwrite( buf, sizeof(char), st, dfp );
	}

	fclose( sfp );
	fclose( dfp );
	return 0;
}

/*
 * copies one file to another, overwriting dest if it exists
*/
int
file_copy( const char *dest, const char *src )
{
	return DoCopy( dest, src, "wb" );
}

/*
 * appends to dest file, creates if it does not exist
*/
int
file_append( const char *dest, const char *src )
{
	return DoCopy( dest, src, "ab" );
}
