/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_TERMINAL_H
#define INCLUDED_TERMINAL_H
#include "typedef.h"
#include "_termctl.h"
#include "_termint.h"

#define MAX_INTERP 20
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class zTerminal
{
public:
	zTerminal();
	~zTerminal();

	Boolean busy() const { return m_busy; }

	void flush(Boolean display = True);
	void handle(uchar aChar);
	void handle(uchar *aString);
	void handle(char *aString) { handle((uchar*)aString);  }

	void clrScr()              { m_ctrl->clr_scr();         }
	void clrEol()              { m_ctrl->clr_eol();         }
	void setRows(int nRows)    { m_ctrl->set_rows(nRows);   }
	void setCols(int nCols)    { m_ctrl->set_cols(nCols);   }
	void setFg(int fg)         { m_ctrl->set_fg(fg);        }
	void setBg(int bg)         { m_ctrl->set_bg(bg);        }
	void setColor(int attrib)  { m_ctrl->set_color(attrib); }
	void gotoXY(int x, int y)  { m_ctrl->cursor_xy(x,y);    }

	int  getLines() const      { return m_ctrl->get_lines(); }
	int  getRows()  const      { return m_ctrl->get_rows();  }
	int  getCols()  const      { return m_ctrl->get_cols();  }
	int  getFg()    const      { return m_ctrl->get_fg();    }
	int  getBg()    const      { return m_ctrl->get_bg();    }
	int  getColor() const      { return m_ctrl->get_color(); }
	int  getX()     const      { return m_ctrl->get_x();     }
	int  getY()     const      { return m_ctrl->get_y();     }

	void RegisterHandler(term_interp *handler);
	void EnableHandler(term_interp *handler, Boolean enable);
	void UnloadHandler(term_interp *handler);
	void RegisterCtrlHandler(term_ctrl *handler);

	enum state_t { ok = 0, fail = 1, eos = 2 };

private:
	state_t handleChar(uchar aChar);

	term_interp *m_interp[MAX_INTERP];
	term_ctrl   *m_ctrl;
	term_ctrl   *m_TermCtrl;
	term_buff   *m_buff;
	Boolean      m_busy;
	int          m_nCurInterp;
	int          m_nLastInterp;
	int          m_nInterp;
};

#endif /* INCLUDED_TERMINAL_H */