/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "str.h"

/*
 * strichr: searches for a character c in string s, case insensitive
*/
char*
strichr( const char *s, int c )
{
    const char *p;
	int ch = toupper(c);

	/* special case with the terminator char */
	if( 0 == ch ) return &((char *)s)[strlen(s)];

	/* do a normal search */
	for( p = s; *p; ++p )
		if( toupper(*p) == ch ) return (char *)p;

	return NULL;
}
