/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "parsevar.h"
#include "stdmac.h"
#include <string.h>

// this function parses the string variables represented as the proboard
// macros "@<>@" in the input buffer. the result will contain the original
// text but with the macros replaced. the resulting size will not exceed
// maxlen characters (inlcuding the terminating NUL)
void
ParseStringVars(char *input, char *result, short maxlen)
{
	size_t  len = 0;
	char   *p   = 0;

	while( EOS != *input && len < maxlen )
	{
		switch( *input )
		{
			case '@':
				p = strstr(input, ">@");
				if( '<' == input[1] && p )
				{ // probably a macro
					char var[50], *pend; // big enough :-)
					pend = (char*)memccpy(var, &input[2], '>', sizeof(var));
					pend[-1] = EOS; // cut off the final part
					input += strlen(var) + 4; // skip over the macro
					// now, parse the macro, copy to result, increment len
					parse_macro(&result[len], var);
					len = strlen(result);
				}
				else goto copy_char; // not well-formed macro
			break;

			default  : // just copy the character
			copy_char: result[len++] = *input++;
		}
	}
	result[len] = EOS;
}
