/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "parsevar.h"
#include "parsedef.h"
#include "proboard.h"
#include "pblsdk.h"
#include "terminal.h"

#ifndef PB_SDK
	#include <stdlib.h>
	#include "emulator.h"
#endif

/*
 * t h e   a c t i o n   c o n t r o l   f u n c t i o n
 * 
 * this function performs the actions requested by action codes. note that
 * the second parameter is interpreted differently according to the action
 * code requested. it is the user's responsibility to ensure correct values!
*/
Boolean
parse_action(int action, char *data)
{
	Boolean retval  = True;

#ifdef PB_SDK /* local terminal object */
	zTerminal terminal, *Terminal = &terminal;
	ansi_interp     ansi;
	avatar_interp   avatar;
	proboard_interp proboard;

	terminal.RegisterHandler(&avatar);
	terminal.RegisterHandler(&proboard);
	terminal.RegisterHandler(&ansi);
#endif

	switch( action )
	{
		case PDEF_ACTION_HANGUP:
			HangUp();
			break;

		case PDEF_ACTION_PAUSE:
			pb_askenter();
			break;

		case PDEF_ACTION_DISPLAY:
			pb_showfile(data,0,pb_getdir(PBDIR_TEXT),Terminal);
			break;

		case PDEF_ACTION_CLREOL:
			Terminal->clrEol();
			break;

		case PDEF_ACTION_CLRSCR:
			Terminal->clrScr();
			break;

		case PDEF_ACTION_PROMPT:
			pb_showlang(atoi((char*)data), Terminal);
			break;

		case PDEF_ACTION_PEXEC:
			pb_runpex(data);
			break;

		case PDEF_ACTION_EXEC:
			pb_runexe(data);
			break;

		default:
			retval = False;
	}

	return retval;
}
