/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "proboard.h"
#include "pblsdk.h"

// formats access flags into a local buffer
char*
pb_formatflag( flagformat_t how, ulong flags )
{
	static char  buf[33];
		   char *p = buf;
		   int   i;

	for( i = 1; i <= 26; ++i ){
		if( flags & l_shl(1L, 32 - i) ) *p++ = '@' + i;
		else *p++ = '-';
	}
	for( i = 5; i >= 0; --i ){
		if( flags & l_shl(1L, i) ) *p++ = '6' - i;
		else *p++ = '-';
	}
	*p = EOS;

	switch( how ){
		case FLAGFMT_A: buf[8]  = EOS; return buf;
		case FLAGFMT_B: buf[16] = EOS; return &buf[8];
		case FLAGFMT_C: buf[24] = EOS; return &buf[16];
		case FLAGFMT_D: return &buf[24];
		default       : return buf;
	}
}

