/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "febbs.h"
#include "str.h"
#include "file.h"
#include "utils.h"

#ifndef PB_SDK
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

void
zFileAreaDir::free()
{
	while( 0 <= --count ) delete[] paths[count];
}

void
zFileAreaDir::SetPath(const char *path, int areano, Boolean bCdrom)
{
	char tmp[MAXPATH];

	free();
	// check for a FA_<n>.CTL file
	sprintf(tmp, "FA_%d.CTL", areano);
	if( 0 != stristr(path, tmp) )
	{
		count = 0;
		FILE *fp = fopen(path, "rt");
		fgets(tmp, sizeof(tmp) - 1, fp);
		while( !feof(fp) && count < MAXPATH )
		{
			char *p = tmp + strlen(tmp) - 1;
			if( p > tmp && '\n' == *p ) *p = EOS;
			file_appchr(tmp, 0); // add the backslash, if needed
			paths[count] = newStr(tmp);
			count++;
			fgets(tmp, sizeof(tmp) - 1, fp);
		}
		fclose(fp);
	}
	else
	{  // normal area definition
		count = 1;
		file_appchr(tmp, path); // add backslash if needed
		paths[0] = newStr(tmp);
	}

	cdrom = bCdrom;
}

char*
zFileAreaDir::Find(const char *fileName)
{
	static char path[MAXPATH];

	for( int i = 0; i < count; ++i )
	{
		sprintf(path, "%s%s", paths[i], fileName);
		// if this is a cd-rom area, assume ok
		if( cdrom || file_exist(path) ) return path;
	}
	return NULL;
}
