/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "fbase.h"
#include "stdmac.h"
#include "proboard.h"
#include "pbnames.h"

#ifndef PB_SDK
	#include <string.h>
#endif

/*
 * f i l e   u p l o a d   l o g   p a r s e r
 * 
 * this module implements the parser for the standard proboard upload logfile
*/

zFileUpload::zFileUpload():
	m_found(False)
{
	m_fp = pb_fopen(fnUPLOADLOG, "rt", PBDIR_SYS);
}

zFileUpload::~zFileUpload()
{
	if( m_fp ) fclose(m_fp);
}

Boolean
zFileUpload::Load(char *file, struct tm *datep, char *uploader)
{
	char buf[255], mon[4];

	if( !m_fp ) return False;

	m_found = False;
	fgets(buf, sizeof(buf), m_fp);
	if( !feof(m_fp) )
	{
		memset(&m_date, 0, sizeof(m_date));
		sscanf( buf, "%2d-%3s-%2d %2d:%2d:%2d %*6c %*2c %12s",
				&m_date.tm_mday, mon, &m_date.tm_year, &m_date.tm_hour,
				&m_date.tm_min, &m_date.tm_sec, m_file );
		// names can contain whitespace: copy and get rid of the CR
		strcpy( m_name, &buf[46] );
		m_name[strlen(m_name) - 1] = EOS;
		// find out the month
		for( int i = 0; i < 12; ++i )
		{
			char *moname[12] = {"Jan","Feb","Mar","Apr","May","Jun",
								"Jul","Aug","Sep","Oct","Nov","Dec"};
			if( !stricmp(moname[i], mon) )
			{
				m_date.tm_mon = i;
				break;
			}
		}
		// adjust all the fields here
		mktime(&m_date);
		// now see if we want to copy the results
		if( file     ) strcpy(file, m_file);
		if( datep    ) memcpy(datep, &m_date, sizeof(m_date));
		if( uploader ) strcpy(uploader, m_name);
		// we're all set
		m_found = True;
	}
	return m_found;
}

const char*
zFileUpload::GetFile() const
{
	if( m_found ) return m_file;
	else return 0;
}

const char*
zFileUpload::GetName() const
{
	if( m_found ) return m_name;
	else return 0;
}

const struct tm*
zFileUpload::GetDate() const
{
	if( m_found ) return &m_date;
	else return 0;
}
