/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"
#include "str.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <conio.h>
	#include <dos.h>
	#include "compiler.h"
	#define  CheckChar() key_inkey()
#else
	#include "pblibc.h"
	#include "pblsdk.h"
	#define  CheckChar() PeekChar()
#endif

/*
 * twirls the prompt strings in the array strs, waiting for a key in hkeys
*/
int twirl_delay = 4;

char
effect_twirl( const char **strs, const char *hkeys, int x, int y )
{
	int  i = 0;
	char ch;

	while( 1 )
	{
		gotoxy( x, y );
		printf( strs[i++] );
		if( NULL == strs[i] ) i = 0;
		ch = CheckChar();
		if( strichr(hkeys, ch) ) return ch;
		delay( twirl_delay );
	}
}
