/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"

#ifndef PB_SDK
	#include <string.h>
	#include <stdlib.h>
	#include <conio.h>
	#include <dos.h>
	#include "compiler.h"
#else
	#include "pblibc.h"
	#include "pblsdk.h"
#endif

int scroll_delay = 80;
extern void _putns(const char *s, int nchars);

void
effect_scroll_left( char *s, int sx, int sy, int ex, Boolean early )
{
	char *text, *p;
	int   curx, skip = 1;

	/* create duplicate of s with space at the end */
	if( NULL == (text = (char *)malloc( strlen(s) + 2 )) ) return;
	strcat( strcpy( text, s ), " " );

	/* scroll that string */
	for( curx = ex, p = text; *p; curx = ((curx > sx) ? curx - 1 : sx) )
	{
		gotoxy( curx, sy );
		if( curx == sx )
		{
			if( skip ) skip = 0;
			else if( early ) break;
			else p++;
		}
		_putns( p, ex - curx + 1 );
		delay( scroll_delay );
	}

	free( text );
}

/*
 * scrolls a string from left to right.
*/
void
effect_scroll_right( char *s, int sx, int y, int ex, Boolean early )
{
	char *text;
	int   curx, len, n;

	len = strlen(s);

	if( NULL == (text = (char *)malloc( len + 2 )) ) return;
	strcat( strcpy(text, " "), s );
	len++;

	for( curx = sx, n = len - 1; len; n = (n) ? n - 1 : 0 )
	{
		gotoxy( curx, y );
		if( 0 == n )
		{
			curx++;
			if( len > (ex - curx + 1) )
			{
				if( early ) break;
				len--;
			}
		}
		_putns( &text[n], len - n );
		delay( scroll_delay );
	}

	free( text );
}
