/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "utils.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <stdlib.h>
	#include <dos.h>
	#include <conio.h>
	#include "compiler.h"
	#define  CheckChar() key_inkey()
#else
	#include "pblibc.h"
	#include "pblsdk.h"
	#define  CheckChar() PeekChar()
#endif

/*
 * bounce a string within a rectangle
*/
int   bounce_delay = 21;
int   bounce_loops = -1;
uchar bounce_palette[EFFECT_PALSIZE] = { 8, 7, 15, 7, 8 };

char
effect_bounce( char *s, int x1, int y1, int x2, int y2, Boolean cycle )
{
	int   curx, cury, incx, incy;
	char *sd;
	char  ch = 0;
	int   slen = strlen( s );

	/* see if string is too long for the window */
	if( slen >= (x2 - x1 + 1) ) return 0;

	/* allocate the delete string: all spaces */
	if( NULL == (sd = (char *)malloc(slen + 1)) ) return 0;
	memset( sd, ' ', slen ); sd[slen] = EOS;

	/* init starting variables and display string */
	curx = x1; cury = y1; incx = 1; incy = 1;
	x2 -= slen;  /* adjust end to allow for whole string */

	if( cycle ) textattr( bounce_palette[0] );
	gotoxy( curx, cury );
	cprintf( s );

	for( int loops = 0 ;; loops++)
	{
		/* see if we need to reverse the increments */
		if( curx == x2 ) incx = -1;
		else if( curx == x1 ) incx = 1;
		if( cury == y2 ) incy = -1;
		else if( cury == y1 ) incy = 1;

		/* erase old string */
		gotoxy( curx, cury );
		cprintf( sd );

		/* display new string */
		curx += incx; cury += incy;
		gotoxy( curx, cury );
		if( cycle ) textattr( bounce_palette[loops % EFFECT_PALSIZE] );
		cprintf( s );

		/* see if we need to terminate */
		if( -1 != bounce_loops && loops == bounce_loops ) break;
		if( 0 != (ch = CheckChar()) ) break;

		delay( bounce_delay );
	}

	free( sd );
	return ch;
}

#undef CheckChar