/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_UTILS_H
#define INCLUDED_UTILS_H
#include "typedef.h"

typedef enum
{
	CURSOR_HIDDEN = 0x2000,
	CURSOR_NORMAL = 0x0D0E,
	CURSOR_BLOCK  = 0x010E
} cursortype_t;

/*
 * m i s c e l l a n e o u s   u t i l i t i e s
 * 
 * these are miscellaneous unclassified utility functions.
*/
int    iswhite(int c);
void   beep();
void   bleep();
ulong  hash(const char *s);
int    fileCRC32(const char *path, ulong *CRC32);
ulong  bufCRC32(const char *buf, size_t len);
char*  p2cStr(char *dest, const char *src, int *len = 0);
char*  c2pStr(char *dest, const char *src);
long   mtol(const char *s);
char*  ltom(long value);
size_t cstrlen(const char *src);
ushort CtrlToArrow(ushort aCode);
char*  newStr(const char *src);
int    hexColor(uchar bg, uchar fg);
void   setCursorType(cursortype_t type);

/*
 * updates the CRC32 value: c is the new int, crc is the current CRC32
*/
extern ulong tblCRC32[];    /* pre-calculated table defined in CRC32.C */
#define UpdateCRC32(c,crc) (tblCRC32[(uchar)((c)^(crc)) & 0xff]^(crc>>8))

/*
 * k e y b o a r d   h a n d l i n g   r o u t i n e s
 * 
 * these are the extended keyboard handling and status reporting functions
*/
Boolean key_poke(ushort aCode); //..........put a key in the keyboard buffer
ushort  key_read();  //.......................wait and read the net key code
ushort  key_peek();  //........get code (if any), don't wait, don't retrieve
ushort  key_stat();  //.................................get shift keys state
Boolean key_ishit(); //..................................is a key available?
void    key_flush(); //............................flush the keyboard buffer
ushort  key_inkey(); //..............get code (if any), don't wait, retrieve

/*
 * s y s t e m   u t i l i t y   r o u t i n e s
 * 
 * low-level operating system utility routines and helper functions
*/
//..........................................return values of _dos_detect_os()
#define __DOS  1  //..........................MS-DOS or compatible is running
#define __OS2  2  //....................................OS/2 DOS box detected
#define __WIN  3  //......................................Windows is detected
#define __DV   4  //.........................................DESQview running

enum{                   //..................used by the drive status routines
	dtError,			//.................invalid drive, letter not assigned
	dtFixed,			//............................fixed (hard disk) drive
	dtRemovable,		//......................removable (floppy disk) drive
	dtRemote,			//.............................remote (network) drive
	dtCDROM,			//....................MSCDEX 2.00+ drive CD-ROM drive
	dtSubst,			//.....................................SUBST'ed drive
	dtRAM,				//..........................................RAM drive
	dtDblSpace,			//.......................DoubleSpace compressed drive
	dtReadOK,			//...........drive ready for reading (removable only)
	dtWriteOK,			//..........drive ready for writing (implies reading)
	dtNotReady			//......................drive is valid, but not ready
};

int  _dos_ansi_loaded( void );   //......test if ansi.sys (or compat) present
int  _dos_share_loaded( void );  //............test if file sharing available
int  _dos_detect_os( void );     //...........detect current operating system
void _dos_idle( void );          //........give up timeslices to multitaskers
int  _dos_drvnum( void );        //...............return the number of drives
int  _dos_drvtype( int drive );  //.....................return the drive type
int  _dos_drvready( int drive ); //.................return drive ready status
int  _dos_version( void );       //................return current dos version
int  _dos_lock(int fd, long whence, long len);    //......lock region in file
int  _dos_locknow(int fd, long whence, long len); //.........lock immediately
int  _dos_unlock(int fd, long whence, long len);  //.......unlock file region

#define EFFECT_PALSIZE  5   //...................default size of the palettes
extern int   fade_delay;    //...........delay between the steps in the fader
extern uchar fade_palette[EFFECT_PALSIZE];    //............the fader palette
extern int   flash_delay;   //....................flasher delay between steps
extern uchar flash_palette[EFFECT_PALSIZE];   //..............flasher palette
extern int   bounce_delay;  //................delay between steps in bouncing
extern int   bounce_loops;  //........number of times to loop through bouncer
extern uchar bounce_palette[EFFECT_PALSIZE];  //.........palette for bouncing
extern int   scroll_delay;  //................delay between steps in scroller
extern int   twirl_delay;   //.................delay between steps in twirler

void effect_fade(char *s, int col, int row);
void effect_flash(char *s, int col, int row);
char effect_bounce(char *s, int x1, int y1, int x2, int y2, Boolean cycle);
void effect_scroll_left(char *s, int x, int y, int endx, Boolean early);
void effect_scroll_right(char *s, int x, int y, int endx, Boolean early);
char effect_twirl(char **s, char *keys, int col, int row);

/*
 * l o g g i n g   a n d   e r r o r   m e s s a g e   r o u t i n e s
 * 
 * various routines which perform error message output and message logging
*/
#ifdef _MSC_VER
#undef fail
#endif

void fail( const char *fmt, ... );
void msgfail( const char *logfile, const char *fmt, ... );
void logfail( const char *logfile, const char *fmt, ... );
void log( const char *logfile, const char *fmt, ... );
void msglog( const char *logfile, const char *fmt, ... );

#endif /* INCLUDED_UTILS_H */
