/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PROFILE_H
#define INCLUDED_PROFILE_H
#include "typedef.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

class zProfile
{
public:
	zProfile();
	~zProfile();

	void    Assign(const char *fname, const char *fext = ".ini");
	void    Close();
	Boolean Open( Boolean bCreate = False );

	char*   ReadString(char *sec, char *entry, char *dest, char *def= 0);
	long    ReadLong(char *sec, char *entry, long *dest, long def);
	short   ReadShort(char *sec, char *entry, short *dest, short def);
	Boolean ReadBool(char *sec, char *entry, Boolean *dest, Boolean def);

	Boolean WriteString(char *section, char *entry, char *value);
	Boolean WriteLong(char *section, char *entry, long value);
	Boolean WriteShort(char *section, char *entry, short value);
	Boolean WriteBool(char *section, char *entry, Boolean value);

	Boolean operator!() const { return Boolean( 0 != m_fp );   }
			operator void *() { return (0 != m_fp) ? this : 0; }

protected:
	char     m_name[MAXPATH];
	Boolean  m_foundSection;
	Boolean  m_mustCopy;
	Boolean  m_useSection;
	FILE    *m_fp;
	FILE    *m_fpCopy;

private:
	char* FindSection(char *section, char *buf, size_t buflen);
	char* FindEntry(char *entry, char *buf, size_t buflen);
};

#endif /* INCLUDED_PROFILE_H */
