#include "slist.h"
#include <iostream.h>
#include <stdio.h>
#include <string.h>

#define ARRAYSZ(a) (sizeof(a) / sizeof(a[0]))

struct TClient
{
	char *name;
	int   age;
} clients[] = {
	{"Branislav", 22},
	{"Joe", 25},
	{"Whatever", 30},
	{"Liza", 22},
	{"Someone else", 33}
};

class TMySortedList: public zSLSortedList
{
public:
	TMySortedList(Boolean shouldDelete = False):
		zSLSortedList(shouldDelete){}

private:
	void *keyOf(void *data) const { return (void *)((TClient *)data)->name; }
    int  compare(void *k1, void *k2) const
		{ return stricmp((char *)k1, (char *)k2); }
};

int
CompareName(void *p1, void *p2)
{
	return stricmp( ((TClient *)p1)->name, ((TClient *)p2)->name );
}

	int
main( void )
{
	zSingleList   list;
	TMySortedList sorted;
	zListIterator iter(list);
	zListIterator i2(sorted);
	zStack        stack;
	zQueue        queue;

    for( int i = 0; i < ARRAYSZ(clients); ++i ){
    	list.link(&clients[i]);
        sorted.link(&clients[i]);
        stack.push(&clients[i]);
        queue.enqueue(&clients[i]);
    }

    cout << "\nList has " << list.size() << " members" << endl;
    iter.begin();
	do{
		cout << ((TClient *)iter())->name << " "
			 << ((TClient *)iter())->age << endl;
	}while( iter.next() );
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t\t\tSorting the list by name..." << endl;
	list.sort( CompareName );
	iter.begin();
	do{
		cout << ((TClient *)iter())->name << " "
			 << ((TClient *)iter())->age << endl;
	}while( iter.next() );
	cout << "\nPress Enter to continue...";
	getchar();

    cout << "\nThe sorted list has " << sorted.size() << " members" << endl;
    i2.begin();
    do{
    	cout << ((TClient *)i2())->name << " "
        	 << ((TClient *)i2())->age << endl;
	}while( i2.next() );
    cout << "\nPress Enter to continue...";
    getchar();

    cout << "\nDeleting first node, appending the third one\n" << endl;
    list.unlink();
    list.append(&clients[2]);
	iter.begin();
    do{
    	cout << ((TClient *)iter())->name << " "
			 << ((TClient *)iter())->age << endl;
	}while( iter.next() );
    cout << "\nPress Enter to continue...";
    getchar();

    cout << "\nDumping the stack\n" << endl;
    while( stack.size() ){
    	TClient *p = (TClient *)stack.pop();
        cout << p->name << " " << p->age << endl;
	}
    cout << "\nPress Enter to continue...";
    getchar();

    cout << "\nDumping the queue\n" << endl;
    while( queue.size() ){
    	TClient *p = (TClient *)queue.dequeue();
        cout << p->name << " " << p->age << endl;
	}
    cout << "\nPress Enter to continue...";
    getchar();

	return 0;
}
