#include "profile.h"
#include <iostream.h>

void
main(int, char *argv[])
{
	zProfile ini;

	ini.Assign(*argv);  // assign to 'PROFTEST.INI'
	ini.Open( True );   // create if file does not exist

	// write some entries
	ini.WriteString("Program", "Name", "ProfTest v1.0");
	ini.WriteString("Program", "Description", "Tests the profile processing");
	ini.WriteString("Program", "Author", "anonymous");
	ini.WriteString("Program", "Company", "Silicon Creations, Inc.");
	ini.WriteString("Program", "RegCode", "909892-MH6203");

	ini.WriteString("Global", "Name", "Test Module");
	ini.WriteString("User", "Name", "");
	ini.WriteString("Cypher", "Non-Entity", NULL);

	ini.WriteString("Program", "Author", "Branislav L. Slantchev");
	ini.WriteString("Program", "RegCode", NULL);
	ini.Close();

	ini.Open(False); // don't create
	if( ini )
	{
		char buf[255];

		ini.ReadString("Program", "RegCode", buf, "n/a");
        cout << buf << endl;
		ini.ReadString("Program", "Author", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("Program", "Name", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("Program", "Description", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("Program", "Company", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("Global", "Name", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("User", "Name", buf, "n/a");
		cout << buf << endl;
		ini.ReadString("Cypher", "Non-Entity", buf, "n/a");
		cout << buf << endl;
	}
}