#include "dlist.h"
#include <iostream.h>
#include <stdio.h>
#include <string.h>

#define NELEM(a) (sizeof(a)/sizeof(a[0]))

struct MyType
{
	int   num;
	int   age;
    char *name;
} array[] = {
	{1,  22, "Branislav"},
	{2,  23, "Duh Man"},
	{3,  46, "Ok, here we go"},
	{4,  10, "Kitty"},
	{5,  50, "Bad attitude"},
	{6,  90, "Now now!"},
	{7,   0, "The intruder"},
	{8,  23, "John Doe"},
	{9,  12, "Charles McCamant"},
	{10, 22, "Twila G. Lehman"},
	{11, 34, "Mark Motl"},
	{12, 45, "K. Elliot"},
	{13, 19, "Charlie Ruster"},
	{14, 49, "Beaches"},
	{15, 72, "Sam Cook"},
	{16, 94, "Sam Cooke"},
	{17, 66, "Ann Margaret"},
};

class TMySorted: public zDLSortedList
{
public:
	TMySorted(Boolean shouldPurge = False): zDLSortedList(shouldPurge){}

private:
	int  compare(void *key1, void *key2);
    void *keyOf(void *data);
};

class TAgeSort: public zDLSortedList
{
public:
	TAgeSort(Boolean shouldPurge = False): zDLSortedList(shouldPurge){}

private:
	int compare(void *key1, void *key2){return *(int *)key1 - *(int *)key2;}
    void *keyOf(void *data){ return (void *)&((MyType *)data)->age; }
};

void print(void *data, void *dummy = 0);
int  compare(void *data, void *orig);
int  CompareName(void *p1, void *p2);

	int
main( void )
{
	zDoubleList list;
    TMySorted   sorted;
    TAgeSort    agesort;

    for( int i = 0; i < NELEM(array); ++i ){
    	list.link(&array[i]);
        sorted.link(&array[i]);
        agesort.link(&array[i]);
    }

	cout << "\n\t>>>>>>>>>> The sorted list:" << endl;
	sorted.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> The age sorted list:" << endl;
	agesort.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\t>>>>>>>>>> List has " << list.size() << " elements.\n" << endl;
	list.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Update 5th element as 2" << endl;
	list.begin();
	list += 4;
	list.update(&array[1]);
	list.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Remove the focus (5th)" << endl;
	list.unlink();
	cout << "\t>>>>>>>>>> List has " << list.size() << " elements now.\n" << endl;
	list.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Prepend 5 and 6" << endl;
	list.end();
	list -= 4;
	list.prepend(&array[5]);
	list.prepend(&array[4]);
	list.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Append 3 and 1" << endl;
	list.append(&array[2]);
	list.append(&array[0]);
	list.forEach(print);
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Traversing the list (w/o last element)" << endl;
	for( list.begin(); !list.atEnd(); list.next() ){
		MyType *p = (MyType *)list();

		cout << p->name << " "
			 << p->age << " "
			 << p->num << endl;
	}
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Traversing the list backwards (w/o first element)" << endl;
	for( list.end(); !list.atStart(); list.prev() ){
		MyType *p = (MyType *)list();

		cout << p->name << " "
			 << p->age << " "
			 << p->num << endl;
	}
	cout << "\nPress Enter to continue...";
	getchar();

	if( list.firstThat(compare, "branislav") ){
		cout << "\n\t>>>>>>>>>> found: " << ((MyType *)list())->name << " "
			 << ((MyType *)list())->age << " "
			 << ((MyType *)list())->num << endl;
	}
	else cout << "\n\t>>>>>>>>>> not found" << endl;
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\nPrint names only" << endl;
	list.begin();
	do{
		cout << ((MyType *)list())->name << endl;
	}while( list++ );
	cout << "\nPress Enter to continue...";
	getchar();

	list.begin(); list += 3;
	zListCursor iter(list, False);
	cout << "\n\t>>>>>>>>>> Construct a cursor at element 4 (list to end)" << endl;
	do{
		cout << ((MyType *)iter())->name << endl;
	}while( iter.next() );
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Synchronizing with the list (at beginning)" << endl;
	list.begin();
	iter.sync();
	do{
		cout << ((MyType *)iter())->name << endl;
	}while( iter.next() );
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Sorting the list by name" << endl;
	list.sort( CompareName );
	list.begin();
	iter.sync();
	do{
		cout << ((MyType *)iter())->name << endl;
	}while( iter.next() );
	cout << "\nPress Enter to continue...";
	getchar();

	cout << "\n\t>>>>>>>>>> Traversing it backwards" << endl;
	iter.end();
	do{
		cout << ((MyType *)iter())->name << endl;
	}while( iter.prev() );
	cout << "\nPress Enter to continue...";
	getchar();

	return 0;
}


	void
print(void *data, void *dummy)
{
	dummy;
	MyType *p = (MyType *)data;

    cout << p->num << ". "
		 << p->name << " of age "
		 << p->age << endl;
}

int
compare(void *data, void *arg)
{
    return stricmp(((MyType *)data)->name, (char *)arg) ? False : True;
}

int
CompareName(void *p1, void *p2)
{
	return stricmp( ((MyType *)p1)->name, ((MyType *)p2)->name );
}

int TMySorted::compare(void *key1, void *key2)
{
	return stricmp((char *)key1, (char *)key2);
}

void *TMySorted::keyOf(void *data)
{
	return (void *)((MyType *)data)->name;
}

