//
// testedit.cpp - zEditLine class usage example (in EXE mode, same in SDK)
//
// Copyright (c) 1996 by Branislav L. Slantchev
// A Product of Silicon Creations, Inc.
//
// Source is for purely educational purposes only. It is provided as a
// service to all PB-Lib users. It is not supported by Silicon Creations.
//
#include "edit.h"
#include "dlist.h"
#include "keyboard.h"
#include "kbcodes.h"

#ifndef PB_SDK
	#include <conio.h>
#else
	#include "pblibc.h"
#endif

const char *choice[7] =
{
	"Yes", "No", "Cancel", "Yeppers", "Nada", "Maybe", "Never"
};

int main()
{
	zKeyboard     kbd;          // create a keyboard handler
	zDoubleList   list(False);  // items are static, don't purge them
	keyDownEvent  event;
	zEditLine    *lines[6];
	int           nItem;

	// create a normal input line
	lines[0] = new zEditLine(zRect(13,5,50,6), 60);
	// create an input line for numbers (positive/negative)
	lines[1] = new zEditNumber(zRect(13,7,50,8), 60, edit_options::blank);
	// create an input line for date input in American format
	lines[2] = new zEditDate(zRect(13,9,23,10), edit_options::american|edit_options::show);
	// create an input line for a filename input, with wildcards
	lines[3] = new zEditFile(zRect(13,11,50,12), 60, edit_options::wildcards|edit_options::upper);
	// link in some items in the string list
	for( nItem = 0; nItem < 7; ++nItem ) list.link((void *)choice[nItem]);
	// create the combo box with the list we just created
	// the list is not dynamically allocated => no zEditCombo::dispose
	lines[4] = new zEditCombo(zRect(13,13,50,14), edit_options::init, &list);
	// create the password input box
	lines[5] = new zEditPassword(zRect(13,15,50,16), 15);

    // some rudimentary screen initialization
    textattr(7);  clrscr();
	gotoxy(1,5);  cprintf("Edit text  :");
	gotoxy(1,7);  cprintf("Edit number:");
	gotoxy(1,9);  cprintf("Edit date  :");
	gotoxy(1,11); cprintf("Enter file :");
	gotoxy(1,13); cprintf("Toggle item:");
	gotoxy(1,15); cprintf("Enter paswd:");

	// the following are necessary so we can see the input areas
	for( nItem = 1; nItem < 6; ++nItem ) lines[nItem]->draw();

	// this will focus and redraw the first line, that's why we
	// didn't need to call line1.draw() as for the others above
	nItem = 0;
	lines[nItem]->setState(True);

	// loop until Escape is pressed
	kbd.getEvent(event);
	while( kbEsc != event.keyCode ){

		switch( event.keyCode ){
			case kbTab: case kbDown: case kbPadDown:
				lines[nItem]->setState(False);
				nItem = (nItem + 1) % 6;
				lines[nItem]->setState(True);
				break;
			case kbShTab: case kbUp: case kbPadUp:
				lines[nItem]->setState(False);
				nItem = (nItem == 0) ? 5 : nItem - 1;
				lines[nItem]->setState(True);
				break;
			default:
				lines[nItem]->handle(event.keyCode);
		}

		kbd.getEvent(event);
    }

	for( nItem = 0; nItem < 6; ++nItem ) delete lines[nItem];
    return 0;
}
