#include "terminal.h"
#include <stdio.h>

void
main(int argc, char *argv[])
{
	FILE *fp;

	zTerminal           terminal;
	ansi_interp         ansi;
	avatar_interp       avt;
	hexpipe_interp      hex;
	pcboard_interp      pcb;
	remoteaccess_interp ra;
	ansi_ctrl           ansiterm;

	terminal.RegisterHandler(&ansi);
	terminal.RegisterHandler(&avt);
	terminal.RegisterHandler(&hex);
	terminal.RegisterHandler(&pcb);
	terminal.RegisterHandler(&ra);

	terminal.UnloadHandler(&avt);
	terminal.UnloadHandler(&pcb);

	terminal.RegisterCtrlHandler(&ansiterm);

	if( argc > 1 && NULL != (fp = fopen(argv[1], "rb")) )
	{
		int c = fgetc(fp);

		while( !feof(fp) )
		{
			terminal.handle(c);
			c = fgetc(fp);
		}

		fclose(fp);
	}
}