//
// teststat.cpp - zCommandBar class usage example (EXE and SDK modes)
//
// Copyright (c) 1996 by Branislav L. Slantchev
// A Product of Silicon Creations, Inc.
//
// Source is for purely educational purposes only. It is provided as a
// service to all PB-Lib users. It is not supported by Silicon Creations.
//
#include "cmdbar.h"
#include "keyboard.h"
#include "kbcodes.h"

int main( void )
{
	zKeyboard    kbd;
	keyDownEvent event;
	short        cmd = cmNoCommand;
	Boolean      focus = True;

	// this is the original way of creating the list. Note how each
	// new item is appended by passing the pointer as an argument to
	// the constructor of the previos one. This can be very confusing,
	// especially with all the parenthesis that should be appended!
	// Even though it is still OK to use this, the overloaded operator+
	// is probably a better (and definitely much clearer) choice
#if 0
	zCommandItem *items = new zCommandItem("[~S~elect]", 'S', 1,
		new zCommandItem("[~Q~uit]", 'Q', 2,
		new zCommandItem("[~H~ello!]", 'H', 3,
		new zCommandItem("[Aha! ~N~ot]", 'N', 8,
		new zCommandItem("[No ~5~: Fifth]", '5', 4,
		new zCommandItem(0, 'X', 100,	// hidden entry, only hotkey
		new zCommandItem("[~L~ast Item]", 'L', 5,
		new zCommandItem("[~A~nother]", 'A', 6,
		new zCommandItem("[~V~isible]", 'V', 7)))))))));
#endif

	// create a list of items for the status line bar, note that we
	// must allocate them dynamically because of zCommandBar requirements
	// (see the manual). Also note the use of the overloaded operator+
	// for much more readable coding. You can construct the item list as
	// shown stright in the zCommandBar constructor, if you wish to.
	zCommandItem *items =
		new zCommandItem("[~S~elect]", 'S', 1)
		+ *new zCommandItem("[~Q~uit]", 'Q', 200)
		+ *new zCommandItem("[~H~ello!]", 'H', 3)
		+ *new zCommandItem("[Aha! ~N~ot]", 'N', 8)
		+ *new zCommandItem("[No ~5~: Fifth]", '5', 4)
		+ *new zCommandItem(0, 'X', 100)	// hidden entry, only hotkey
		+ *new zCommandItem("[~L~ast Item]", 'L', 5)
		+ *new zCommandItem("[~A~nother]", 'A', 6)
		+ *new zCommandItem("[~V~isible]", 'V', 7);

	// create a status line (the location is usually the best one)
	zCommandBar *status = new zCommandBar(zRect(1,24,80,25), items);

	// just to show you how to disable an item on the status line
	// this will cause the 'Hello' item to be non-selectable
	status->enableCommand(3, False);
    status->draw(); // display the line

    // note that the loop will terminate when either Escape is pressed
    // or when the user chooses 'X' (the invisible item) or 'Quit'
	while( 200 != cmd && 100 != cmd && cmCancel != cmd ){

		kbd.getEvent(event);

		// we use the tab to focus and unfocus the status line
		if( kbTab == event.keyCode ){
			focus = Boolean(!focus);
			if( !focus ) status->options &= ~zCommandBar::focus;
			else status->options |= zCommandBar::focus;
			status->draw(); // needed so the line is shown in proper colors
		}
		// we use Alt+H to hide and Alt+U to unhide the status line
		// note that is will be drawn according to the focus state
		else if( kbAltH == event.keyCode ){
			status->options |= zCommandBar::hide;
			status->draw();
		}
		else if( kbAltU == event.keyCode ){
			status->options &= ~zCommandBar::hide;
            status->draw();
        }
        // just process each keystroke
		else cmd = status->handle(event.keyCode);
    }
    delete status;

    return 0;
}
