#include "dlist.h"
#include <iostream.h>
#include <string.h>
#include <dir.h>
#include <alloc.h>
#include <conio.h>

struct TFileInfo
{
	char name[13];
    long date;
    long size;

    TFileInfo(char *aName, long aDate, long aSize):
    	date(aDate), size(aSize) { strcpy(name, aName); }
};

static void display(TFileInfo *item);

	int
main( int argc, char *argv[] )
{
	zDoubleList dirList(True);
	struct ffblk f;

    if( !--argc ){
    	cerr << "Usage: " << *argv << " filespec" << endl;
		return 1;
    }

    cout << "InitHeap: " << coreleft() << endl;

    // build the list
    cout << "Building the file list...";
    int done = findfirst(argv[1], &f, 0);
    while( !done ){
        if( '.' != f.ff_name[0] ){
        	dirList.link(new TFileInfo(f.ff_name, f.ff_fdate, f.ff_fsize));
            if( dirList.error() ){
            	cerr << "\nOut of memory" << endl;
                return 1;
			}
		}
    	done = findnext(&f);
	}

    cout << "There are " << dirList.size()
		 << " files in " << argv[1] << endl;

    if( dirList.size() ){
		zListCursor c(dirList, True);
	    cout << "Use the arrow keys to display.\n" << endl;
	    display((TFileInfo *)c.get());
		do{
			int ch;

			while( 0 == (ch = getch()) )
				;

			switch( ch ){
				case 0x1b: goto Quit;

				case 0x4b:
					c.begin();
					display((TFileInfo *)c.get());
				break;

				case 0x4d:
					c.end();
					display((TFileInfo *)c.get());
				break;

				case 0x50:
					if( c.next() ) display((TFileInfo *)c.get());
					else cerr << ">>At end of list." << endl;
				break;

				case 0x48:
					if( c.prev() ) display((TFileInfo *)c.get());
					else cerr << ">>At start of list." << endl;
				break;

				default:
					cerr << ">>Up/Down/Left/Right/Escape are recognized." << endl;
			}
		}while(1);
	}

Quit:
	dirList.~zDoubleList();
    cout << "TermHeap: " << coreleft();
	return 0;
}


void display(TFileInfo *item)
{
	if( 0 == item ) cerr << "No item" << endl;
    else{
    	cout << "'" << strlwr(item->name) << "' "
        	 << item->size << " bytes" << endl;
	}
}