/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_TERMINT_H
#define INCLUDED_TERMINT_H
#include "typedef.h"
#include "_termbuf.h"

class term_ctrl;

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class term_interp
{
public:
	term_interp();
	virtual ~term_interp(){ if( m_buff ) m_buff->flush(); }

	virtual Boolean init(uchar aSOS)    = 0;
	virtual void    handle(uchar aChar) = 0;

	Boolean fail() const { return m_fail; }
	Boolean eos()  const { return m_eos;  }

	void RegisterCtrlHandler(term_ctrl *ctrl) { m_ctrl = ctrl;     }
	void RegisterBuffer(term_buff *buff)      { m_buff = buff;     }
	void Enable(Boolean enable)               { m_active = enable; }

protected:
	Boolean    m_fail;
	Boolean    m_eos;
	Boolean    m_active;
	term_ctrl *m_ctrl;
	term_buff *m_buff;
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class ansi_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class avatar_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class hexpipe_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class proboard_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class pcboard_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class remoteaccess_interp: public term_interp
{
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);
};

////////////////////////////////////////////////////////////////////////////
// this class handles the ^F and ^K sequences in text files (ProBoard and
// RemoteAccess compatible). also adds some specific codes new to the class!
////////////////////////////////////////////////////////////////////////////
class textcode_interp: public term_interp
{
public:
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);

private:
	Boolean m_kCode;
	int     m_action;
	int     m_maxLen;
	char    m_justifyChar;
};

////////////////////////////////////////////////////////////////////////////
// this class interprets the special @<>@ macros (semi ProBoard-compatible)
// format with a lot of additional features. works for ProBoard environments
////////////////////////////////////////////////////////////////////////////
class macro_interp: public term_interp
{
public:
	Boolean init(uchar aSOS);
	void    handle(uchar aChar);

private:
	char m_prevChar;
};

#endif /* INCLUDED_TERMINT_H */
