/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_TERMCTL_H
#define INCLUDED_TERMCTL_H
#include "typedef.h"

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class term_ctrl
{
public:
	virtual void clr_scr()           { cursor_xy(1,1);   }
	virtual void clr_eol()           { /* null */;       }
	virtual void set_fg(int fg)      { m_fg = fg;        }
	virtual void set_bg(int bg)      { m_bg = bg;        }
	virtual void set_color(int attr) { m_bg = attr >> 4; m_fg = attr & 0xf; }

	virtual int  put(char aChar)     { return put(&aChar, 1); }
	virtual int  put(const char *s, size_t n);

	virtual void cursor_up(int rows);
	virtual void cursor_down(int rows);
	virtual void cursor_left(int cols);
	virtual void cursor_right(int cols);
	virtual void cursor_xy(int x, int y);

	static void set_rows(int nRows) { m_rows = nRows;   }
	static void set_cols(int nCols) { m_cols = nCols;   }

	static int  get_lines()         { return m_lines;   }
	static int  get_rows()          { return m_rows;    }
	static int  get_cols()          { return m_cols;    }
	static int  get_fg()            { return m_fg;      }
	static int  get_bg()            { return m_bg;      }
	static int  get_x()             { return m_x;       }
	static int  get_y()             { return m_y;       }
	static int  get_color()         { return (m_bg << 4) | m_fg; }

private: // these are shared by all instances
	static int m_x;
	static int m_y;
	static int m_fg;
	static int m_bg;
	static int m_rows;
	static int m_cols;
	static int m_lines;
};

class console_ctrl: public term_ctrl
{
public:
	console_ctrl();
	void clr_scr();
	void clr_eol();
	void set_fg(int fg);
	void set_bg(int bg);
	void set_color(int attrib);
	void cursor_xy(int x, int y);
	void cursor_up(int rows);
	void cursor_down(int rows);
	void cursor_left(int cols);
	void cursor_right(int cols);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class ansi_ctrl: public term_ctrl
{
public:
	ansi_ctrl();
	void clr_scr();
	void clr_eol();
	void set_fg(int fg);
	void set_bg(int bg);
	void set_color(int attrib);
	void cursor_xy(int x, int y);
	void cursor_up(int rows);
	void cursor_down(int rows);
	void cursor_left(int cols);
	void cursor_right(int cols);
};

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
class avatar_ctrl: public term_ctrl
{
public:
	avatar_ctrl();
	void clr_scr();
	void clr_eol();
	void set_fg(int fg);
	void set_bg(int bg);
	void set_color(int attrib);
	void cursor_xy(int x, int y);
	void cursor_up(int rows);
	void cursor_down(int rows);
	void cursor_left(int cols);
	void cursor_right(int cols);
};

#endif /* INCLUDED_TERMCTL_H */
