/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_USERON_H
#define INCLUDED_USERON_H

/*
 * u s e r   o n l i n e   s u p p o r t
 * 
 * declaration of the class which supports both doing and userdoes drop files
*/
#include "typedef.h"

class zUserOnline
{
public:
	zUserOnline(Boolean UserDoes = True, Boolean Doing = True);

	void  Create(short nNode, char *text);
	void  Remove(short nNode);
	char *GetUserDoes(short nNode, char *text);
	char *GetDoing(short nNode, char *text);

private:
	void CreateUserDoes(short nNode, char *text);
	void CreateDoing(short nNode, char *text);
	void RemoveUserDoes(short nNode);
	void RemoveDoing(short nNode);
	void InitDoing();

	static const short m_MaxUserDoesLen;
	static const short m_MaxDoingLen;

	Boolean m_UserDoes;
	Boolean m_Doing;
};

#endif /* INCLUDED_USERON_H */
