/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PROGBAR_H
#define INCLUDED_PROGBAR_H
#include "geometry.h"

/*
 * p r o g r e s s   b a r   i n d i c a t o r   c l a s s
 * 
 * progress bar thermometer indicator class with adjustable colors and bars
*/

// the default characters and attributes for the background = 256*attr + char
static const ushort _barfg = 0x0700 | ('' & 0x00ff);
static const ushort _barbg = 0x0700 | ('' & 0x00ff);

class zProgBar
{
public:
	zProgBar(zRect &r, ushort fg = _barfg, ushort bg = _barbg);

    void  update(ulong aStepSize);
	void  setTotal(ulong aTotal) { taskSize = aTotal; }
	short getPerCent() const { return curPercent % 101; }

protected:
	void  draw();

protected:
	zRect bounds;		//............the bounds of the thermometer rectangle
	short pctPerChar;	//.....percent change needed to advance one character
	short adjCount;     //...................percent that need to be adjusted
	short curOffset;	//.................current offset of the progress bar
	short curPercent;	//...........current percentage of the task completed
	short pct;          //............................this is used internally
	ulong taskSize;		//.............................size of the whole task
	ulong curProgress;	//..........................current size of task done
	zPoint size;		//.............the size (height and width) of the bar

    uchar foreChar;
    uchar foreAtrib;
};

#endif /* INCLUDED_PROBAR_H */
