
#include <stdio.h>

#include "luthor.h"
#include "basicdef.h"
#include "basictab.h"

int main(int argc,char **argv)
{
	int lextable,lexstream,t;

    LexInit(0);		/* initialize the lex processor */
    lextable=LexSetObject(&BASICObject);
	if(lextable==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
	
    lexstream=LexInputByCall(lextable);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    while((t=BuildToken(lexstream,SubmitChar())) != EOF){
    	if(t){
	    	printf("%d\t ",t);
	    	if(t==TK_EOL){
	        	printf("\\n\n");
			} else {
	        	printf("%s\n",ThisTokenText(lexstream));
			}
		} else {
        	/*
            ** using this technique, t==0 is not an error but simply
            ** indicates that a full token has not been built yet.
            */
		}
	}
    printf("EOF\n");
    exit(0);
}

char *buffer = "FOR X=1 TO 1000\n\tPRINT X\nNEXT X";

int SubmitChar()
{
	static int x;
    int c;
    
    c=buffer[x];
    if(c){
    	x++;
        return(c);
	} else {
    	return(EOF);
	}
}
