
/****************************************************************************
*																			*
*								LUTHOR.H									*
*																			*
****************************************************************************/

#if !defined(SPAN_DONE)

#define SPAN_DONE


#if !defined(LEX_DONE)
	typedef unsigned int uint;
#endif

typedef int LEXTABLE;
typedef int LEXSTREAM;

typedef struct lexnodestruct {
	uint token;
	uint left_anchor:1;
	uint right_anchor:1;
	uint table_item_start;
} LEXNODE;

typedef struct lexobjstruct {
	LEXNODE *Node;
	int *TransitionTable;
	uint FirstLex;
	int StartToken;
	int CaseSensitive:1;
} LEXOBJECT;

typedef struct lexinfostruct {
	long	CurLineNumber;
	char *	CurFileName;
	char *	CurLineText;
	int		CurTokenPos;
	int		CurFileDepth;
	int		LexStreamType;
    int		TokenMin;
    int		TokenMax;
    char **	LLTFlagTable;
    char **	LLTTextTable;
} LEXINFO;


/********
* error codes. Some of these are for lexgen, some are for engine. Should be
* split up probably.
*/

#define LXE_ERROR		-3	/* indicates that an error has occured */
#define LXE_NOTRAN		-2	/* returned by BuildToken if no token is possible */
#define LXE_NOMEM		1	/* out of memory */
#define LXE_USAGE		2	/* bad parameters or options */
#define LXE_FILERR		3	/* error while reading or writing to a file */
#define LXE_LOGIC		4	/* internal error - note circumstances & notify InnerSystem */
#define LXE_NOFILE		5	/* specified file not found */
#define LXE_BADFILE		6	/* file is not in proper format (usually LLT file) */
#define LXE_BADPARAMS	7	/* bad parameters passed to function */
#define LXE_MAX			7

/*
** LUTHOR input types
*/

#define LIT_BYSTRING	0
#define LIT_BYFILE		1
#define LIT_BYFUNC		2
#define LIT_BYBUILD		3

/*
** LUTHOR initialization options
*/

#define LO_SUPPRESS	0x01

/*
** LexSubmitString option types
*/

#define SSO_ATEND		0
#define SSO_ATSTART		1
#define SSO_REPLACE		2


/********
* global vars
*/

extern int lexerror;


/********
* function prototypes
*/

void LexInit(uint opts);

LEXTABLE LexSetObject(LEXOBJECT *item);
LEXTABLE LexLoadObject(char *filename);

LEXSTREAM LexInputFile(LEXTABLE lextabnum,char *filename);
LEXSTREAM LexInputFunction(LEXTABLE lextabnum,int (*fn)());
LEXSTREAM LexInputByCall(LEXTABLE lextabnum);

LEXTABLE LexChangeTable(LEXSTREAM lexstrnum,LEXTABLE lextabnum);
int LexPushFile(LEXSTREAM lexstrnum,char *filename);
int LexCloseFile(LEXSTREAM lexstrnum);
int LexCloseStream(LEXSTREAM lexstrnum);
int LexFreeObject(LEXTABLE lextabnum);

int ThisToken(LEXSTREAM x);
char *ThisTokenText(LEXSTREAM x);
int AdvanceToken(LEXSTREAM x);
int NextToken(LEXSTREAM x);
char *NextTokenText(LEXSTREAM x);
int BuildToken(LEXSTREAM x,int c);
int ThisChar(LEXSTREAM x);
int AdvanceChar(LEXSTREAM x);
LEXINFO *LexLineInfo(LEXSTREAM x);
int LexSubmitString(LEXSTREAM x,char *s,int opt);
char *LexErrorString(int lexerrnum);


#endif


