unit demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, EnhVoiceCommand, ComCtrls;

type
  TForm1 = class(TForm)
    voice: TEnhVoiceCommand;
    Label1: TLabel;
    BTTrain: TBitBtn;
    BTAbout: TBitBtn;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    YouSaid: TLabel;
    VUMeter: TProgressBar;
    procedure BTTrainClick(Sender: TObject);
    procedure BTAboutClick(Sender: TObject);
    procedure voiceVUMeter(sender: TObject; level: Integer);
    procedure voiceCommandRecognize(sender: TObject; ID: Longint;
      ApplicationName, StateName: string; flags, ActionSize: Longint;
      action: Pointer; NumLists: Longint; ListValues: PChar;
      command: string);
    procedure voiceCommandOther(sender: TObject; ApplicationName,
      StateName, command: string);
    procedure voiceUtteranceBegin(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BTTrainClick(Sender: TObject);
begin
voice.TrainGeneral(handle,'');
end;

procedure TForm1.BTAboutClick(Sender: TObject);
begin
voice.AboutDlg(handle,'');
end;

procedure TForm1.voiceVUMeter(sender: TObject; level: Integer);
begin
VUMeter.position:=trunc(longint(level)/$FFFF*100);
end;

procedure TForm1.voiceCommandRecognize(sender: TObject; ID: Longint;
  ApplicationName, StateName: string; flags, ActionSize: Longint;
  action: Pointer; NumLists: Longint; ListValues: PChar; command: string);
begin
YouSaid.caption:=command;
end;

procedure TForm1.voiceCommandOther(sender: TObject; ApplicationName,
  StateName, command: string);
begin
YouSaid.caption:='<undecipherable>';
end;

procedure TForm1.voiceUtteranceBegin(Sender: TObject);
begin
YouSaid.caption:='';
end;

end.
