// FILE: Referenced.h
//
// (c) 1996 Mayur Patel
//

#ifndef Referenced_CLASS
#define Referenced_CLASS

// *******************************************************************
// CLASS: Referenced
// DESCRIPTION:
//    Tracking references helps an object to manage its own
//    deallocation.
// NOTE:
//    Never call <operator delete> on a referenced object.
//    Use Referenced::unregisterReference();
//
class Referenced {
   public:
      Referenced(void)			{ _uReferences = 1; }
      virtual ~Referenced(void)		{}
      
      void registerReference()		{ _uReferences++; }
      void unregisterReference();
      unsigned countReferences()	{ return (_uReferences);}
      
  private:
     unsigned _uReferences;
};

#endif
