// File: ImageMan.C
//
// (c) 1996 Mayur Patel

#include <SampledImage.h>
#include <ImageMan.h>
#include <ImageTile.h>

#include <assert.h>
//
// default settings at application startup:
//
ImageMan *ManReference::_pManager = 0;
unsigned ManReference::_uReferences = 0;


ManReference::ManReference( void )
{
   if ( !_pManager )
   {
      assert( !_uReferences );
      _pManager = new ImageMan();
   }
   if ( _pManager )
      _uReferences++;
   return;
}


ManReference::~ManReference( void )
{
   if ( _pManager )
      _uReferences--;
   if (( !_uReferences )&& _pManager )
   {
      delete _pManager;
      _pManager = 0;
   }
   return;
}

// ************************************************************************


ImageMan::~ImageMan( void )
{
   return;
}


ImageTile *
ImageMan::newTile( SampledImage *pCaller, const ImageArea& area )
{
   ImageTile		*pRet = 0;

   if ( pCaller )
   {
      pRet = new ImageTile( area, pCaller->getType() );

      if ( pRet )
	 pCaller->fillTile( pRet );
   }
   
   return ( pRet );
}
