// File: SGIWriter.h
//
// (c) 1996 Mayur Patel
//

#ifndef SGIWriter_CLASS
#define SGIWriter_CLASS

#include <Referenced.h>

#include <Type.h>
#include <InputImage.h>
#include <SampledImage.h>
#include <ImageTile.h>

#include <fstream.h>

// *******************************************************************
// CLASS: SGIWriter
// DESCRIPTION:
//    Output image for SGI RGB format (8bpp or 16bpp)
//
class SGIWriter : public Referenced {
  public:
    SGIWriter( const char *cpFile, SampledImage *pInput );

    SGIWriter( 
       const char *cpFile, 
       SampledImage *pInput, 
       Type setType );

    SGIWriter( 
       const char *cpFile, 
       InputImage *pInput, 
       const ImageArea& setArea, 
       Type setType = UShort )
    { _iOK = writeSGIFile( cpFile, pInput, setArea, setType );}

    ~SGIWriter( void ) { }

    int
    isOkay( void ) const
    { return( _iOK ); }

  protected:   
    int		_iOK;

    int
    writeSGIFile( 
       const char *cpFilename, 
       InputImage *pInput, 
       const ImageArea& area, 
       const Type setType );

    int
    validateFile( 
       ofstream& outfile, 
       const ImageArea& area, 
       const Type setType );

    int
    writeRows( 
       ofstream& outfile, 
       InputImage *pInput, 
       const ImageArea& area, 
       const Type setType );

    void
    _commit( 
       ofstream& outfile, 
       void *vpBuffer, 
       unsigned uPixels, 
       Type setType );

    void
    castFromShort( unsigned char *cp, unsigned short sWord)
    { cp[0] = ( sWord >> 8 ) & 0xFF; cp[1] = sWord & 0xFF; }

    void
    castFromLong( unsigned char *cp, unsigned long lWord )
    { cp[0] = ( lWord >> 24 ) & 0xFF; 
      cp[1] = ( lWord >> 16 ) & 0xFF; 
      cp[2] = ( lWord >> 8 ) & 0xFF; 
      cp[3] = ( lWord & 0xFF ); 
    }

};

#endif

